/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.JdbcMapperBuilder;
import org.sfm.jdbc.JdbcMapperFactory;
import org.sfm.jdbc.impl.DiscriminatorJdbcMapper;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.reflect.TypeReference;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.Predicate;

public class DiscriminatorJdbcBuilder<T> {
    private final String column;
    private final JdbcMapperFactory jdbcMapperFactory;
    private final List<DiscriminatorJdbcSubBuilder> builders = new ArrayList<DiscriminatorJdbcSubBuilder>();

    public DiscriminatorJdbcBuilder(String column, JdbcMapperFactory jdbcMapperFactory) {
        this.column = column;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public DiscriminatorJdbcSubBuilder when(String value, Type type) {
        return this.when(new DiscriminatorPredicate(value), type);
    }

    public DiscriminatorJdbcSubBuilder when(Predicate<String> predicate, Type type) {
        DiscriminatorJdbcSubBuilder subBuilder = new DiscriminatorJdbcSubBuilder(predicate, type);
        this.builders.add(subBuilder);
        return subBuilder;
    }

    public DiscriminatorJdbcSubBuilder when(String value, Class<? extends T> type) {
        return this.when(value, (Type)type);
    }

    public DiscriminatorJdbcSubBuilder when(String value, TypeReference<? extends T> type) {
        return this.when(value, type.getType());
    }

    public JdbcMapper<T> mapper() {
        ArrayList mappers = new ArrayList();
        for (DiscriminatorJdbcSubBuilder subBuilder : this.builders) {
            JdbcMapper mapper = subBuilder.builder != null ? (JdbcMapper)subBuilder.builder.mapper() : this.jdbcMapperFactory.newMapper(subBuilder.type);
            mappers.add(new Tuple2(subBuilder.predicate, mapper));
        }
        return new DiscriminatorJdbcMapper(this.column, mappers, this.jdbcMapperFactory.rowHandlerErrorHandler());
    }

    public class DiscriminatorJdbcSubBuilder {
        private final Type type;
        private final Predicate<String> predicate;
        private JdbcMapperBuilder<T> builder = null;

        public DiscriminatorJdbcSubBuilder(Predicate<String> predicate, Type type) {
            this.type = type;
            this.predicate = predicate;
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column) {
            return this.addMapping(column, FieldMapperColumnDefinition.identity());
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
            if (this.builder == null) {
                this.builder = DiscriminatorJdbcBuilder.this.jdbcMapperFactory.newBuilder(this.type);
            }
            this.builder.addMapping(column, columnDefinition);
            return this;
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column, int index, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
            if (this.builder == null) {
                this.builder = DiscriminatorJdbcBuilder.this.jdbcMapperFactory.newBuilder(this.type);
            }
            this.builder.addMapping(column, index, columnDefinition);
            return this;
        }

        public JdbcMapper<T> mapper() {
            return DiscriminatorJdbcBuilder.this.mapper();
        }

        public DiscriminatorJdbcSubBuilder when(String value, Type type) {
            return DiscriminatorJdbcBuilder.this.when(value, type);
        }

        public DiscriminatorJdbcSubBuilder when(String value, Class<? extends T> type) {
            return DiscriminatorJdbcBuilder.this.when(value, type);
        }

        public DiscriminatorJdbcSubBuilder when(String value, TypeReference<? extends T> type) {
            return DiscriminatorJdbcBuilder.this.when(value, type);
        }

        public DiscriminatorJdbcSubBuilder when(Predicate<String> predicate, Type type) {
            return DiscriminatorJdbcBuilder.this.when(predicate, type);
        }
    }

    private static class DiscriminatorPredicate
    implements Predicate<String> {
        private final String value;

        private DiscriminatorPredicate(String value) {
            this.value = value;
        }

        @Override
        public boolean test(String discriminatorValue) {
            return this.value == null ? discriminatorValue == null : this.value.equals(discriminatorValue);
        }

        public String toString() {
            return "DiscriminatorPredicate{value='" + this.value + '\'' + '}';
        }
    }
}

