/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.JdbcMappingContextFactoryBuilder;
import org.sfm.jdbc.ResultSetGetterFactory;
import org.sfm.jdbc.impl.ResultSetEnumarable;
import org.sfm.map.GetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.MappingContext;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.MappingContextFactory;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.mapper.AbstractMapperBuilder;
import org.sfm.map.mapper.JoinMapperImpl;
import org.sfm.map.mapper.KeyFactory;
import org.sfm.map.mapper.MapperSourceImpl;
import org.sfm.map.mapper.StaticSetRowMapper;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.Enumarable;
import org.sfm.utils.UnaryFactory;

public final class JdbcMapperBuilder<T>
extends AbstractMapperBuilder<ResultSet, T, JdbcColumnKey, JdbcMapper<T>, JdbcMapperBuilder<T>> {
    private static final MapperSourceImpl<ResultSet, JdbcColumnKey> FIELD_MAPPER_SOURCE = new MapperSourceImpl<ResultSet, JdbcColumnKey>(ResultSet.class, new ResultSetGetterFactory());
    private static final KeyFactory<JdbcColumnKey> KEY_FACTORY = new KeyFactory<JdbcColumnKey>(){

        @Override
        public JdbcColumnKey newKey(String name, int i) {
            return new JdbcColumnKey(name, i);
        }
    };

    public JdbcMapperBuilder(TypeReference<T> target) {
        this(target.getType());
    }

    public JdbcMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public JdbcMapperBuilder(Type target, ReflectionService reflectService) {
        this(reflectService.getClassMeta(target), MapperConfig.fieldMapperConfig(), new ResultSetGetterFactory(), new JdbcMappingContextFactoryBuilder());
    }

    public JdbcMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> mapperConfig, GetterFactory<ResultSet, JdbcColumnKey> getterFactory, MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> parentBuilder) {
        super(classMeta, parentBuilder, mapperConfig, FIELD_MAPPER_SOURCE.getterFactory(getterFactory), KEY_FACTORY, 1);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType) {
        this.addMapping(column, index, sqlType, FieldMapperColumnDefinition.identity());
        return this;
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), columnDefinition);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, ColumnProperty ... properties) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), properties);
    }

    public JdbcMapperBuilder<T> addMapping(ResultSetMetaData metaData) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            this.addMapping(metaData.getColumnLabel(i), i, metaData.getColumnType(i));
        }
        return this;
    }

    @Override
    protected JdbcColumnKey key(String column, int index) {
        return new JdbcColumnKey(column, index);
    }

    @Override
    protected JdbcMapper<T> newJoinJdbcMapper(Mapper<ResultSet, T> mapper) {
        return new JoinDatastaxMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), this.mappingContextFactoryBuilder.newFactory());
    }

    @Override
    protected JdbcMapper<T> newStaticJdbcMapper(Mapper<ResultSet, T> mapper) {
        return new StaticJdbcSetRowMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), this.mappingContextFactoryBuilder.newFactory());
    }

    public static class StaticJdbcSetRowMapper<T>
    extends StaticSetRowMapper<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public StaticJdbcSetRowMapper(Mapper<ResultSet, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, new ResultSetEnumarableFactory());
        }
    }

    private static class ResultSetEnumarableFactory
    implements UnaryFactory<ResultSet, Enumarable<ResultSet>> {
        private ResultSetEnumarableFactory() {
        }

        @Override
        public Enumarable<ResultSet> newInstance(ResultSet rows) {
            return new ResultSetEnumarable(rows);
        }
    }

    public static class JoinDatastaxMapper<T>
    extends JoinMapperImpl<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public JoinDatastaxMapper(Mapper<ResultSet, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, new ResultSetEnumarableFactory());
        }

        @Override
        public MappingContext<? super ResultSet> newMappingContext(ResultSet rs) {
            return this.newMappingContext();
        }
    }
}

