/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.MultiIndexFieldMapper;
import org.sfm.jdbc.QueryPreparer;
import org.sfm.jdbc.SqlTypeColumnProperty;
import org.sfm.jdbc.impl.CollectionIndexFieldMapper;
import org.sfm.jdbc.impl.MapperQueryPreparer;
import org.sfm.jdbc.impl.MultiIndexQueryPreparer;
import org.sfm.jdbc.impl.PreparedStatementSetterFactory;
import org.sfm.jdbc.impl.SingleIndexFieldMapper;
import org.sfm.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.PreparedStatementIndexSetterOnGetter;
import org.sfm.jdbc.named.NamedSqlQuery;
import org.sfm.map.AbstractWriterBuilder;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.IndexedSetterFactoryProperty;
import org.sfm.map.column.IndexedSetterProperty;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.Getter;
import org.sfm.reflect.IndexedGetter;
import org.sfm.reflect.IndexedSetter;
import org.sfm.reflect.IndexedSetterFactory;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.ArrayIndexedGetter;
import org.sfm.reflect.impl.ArraySizeGetter;
import org.sfm.reflect.impl.ListIndexedGetter;
import org.sfm.reflect.impl.ListSizeGetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DefaultPropertyNameMatcher;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.utils.ErrorDoc;
import org.sfm.utils.ForEachCallBack;

public class PreparedStatementMapperBuilder<T>
extends AbstractWriterBuilder<PreparedStatement, T, JdbcColumnKey, PreparedStatementMapperBuilder<T>> {
    public PreparedStatementMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> mapperConfig, ConstantTargetFieldMapperFactory<PreparedStatement, JdbcColumnKey> preparedStatementFieldMapperFactory) {
        super(classMeta, PreparedStatement.class, mapperConfig, preparedStatementFieldMapperFactory);
    }

    private PreparedStatementMapperBuilder(PreparedStatementMapperBuilder<T> builder) {
        this(builder.classMeta, builder.mapperConfig, builder.fieldAppenderFactory);
    }

    @Override
    protected Instantiator<T, PreparedStatement> getInstantiator() {
        return new NullInstantiator();
    }

    @Override
    protected JdbcColumnKey newKey(String column, int i, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        JdbcColumnKey key = new JdbcColumnKey(column, i);
        SqlTypeColumnProperty typeColumnProperty = columnDefinition.lookFor(SqlTypeColumnProperty.class);
        if (typeColumnProperty == null) {
            FieldMapperColumnDefinition globalDef = (FieldMapperColumnDefinition)this.mapperConfig.columnDefinitions().getColumnDefinition(key);
            typeColumnProperty = globalDef.lookFor(SqlTypeColumnProperty.class);
        }
        if (typeColumnProperty != null) {
            return new JdbcColumnKey(key.getName(), key.getIndex(), typeColumnProperty.getSqlType(), key);
        }
        return key;
    }

    @Override
    protected int getStartingIndex() {
        return 1;
    }

    public QueryPreparer<T> to(NamedSqlQuery query) {
        return this.to(query, null);
    }

    public QueryPreparer<T> to(NamedSqlQuery query, String[] generatedKeys) {
        PreparedStatementMapperBuilder<T> builder = new PreparedStatementMapperBuilder<T>(this);
        return super.preparedStatementMapper(query, generatedKeys);
    }

    private QueryPreparer<T> preparedStatementMapper(NamedSqlQuery query, String[] generatedKeys) {
        for (int i = 0; i < query.getParametersSize(); ++i) {
            this.addColumn(query.getParameter(i).getName());
        }
        boolean hasMultiIndex = this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>>>(){
            boolean hasMultiIndex;

            @Override
            public void handle(PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                this.hasMultiIndex |= PreparedStatementMapperBuilder.this.isMultiIndex(pm.getPropertyMeta());
            }
        }).hasMultiIndex;
        if (hasMultiIndex) {
            return new MultiIndexQueryPreparer<T>(query, this.buildIndexFieldMappers(), generatedKeys);
        }
        return new MapperQueryPreparer(query, this.mapper(), generatedKeys);
    }

    private boolean isMultiIndex(PropertyMeta<?, ?> propertyMeta) {
        return TypeHelper.isArray(propertyMeta.getPropertyType()) || TypeHelper.isAssignable(List.class, propertyMeta.getPropertyType());
    }

    public MultiIndexFieldMapper<T>[] buildIndexFieldMappers() {
        final ArrayList fields = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>>>(){
            final PreparedStatementSetterFactory setterFactory = new PreparedStatementSetterFactory();

            @Override
            public void handle(PropertyMapping<T, ?, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                if (PreparedStatementMapperBuilder.this.isMultiIndex(pm.getPropertyMeta())) {
                    fields.add(this.newCollectionFieldMapper(pm));
                } else {
                    fields.add(this.newFieldMapper(pm));
                }
            }

            private <P, C> MultiIndexFieldMapper<T> newCollectionFieldMapper(PropertyMapping<T, P, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                IntGetter<List<?>> sizeGetter;
                IndexedGetter indexedGetter;
                PropertyMeta propertyMeta = pm.getPropertyMeta();
                Getter collectionGetter = propertyMeta.getGetter();
                if (TypeHelper.isAssignable(List.class, propertyMeta.getPropertyType())) {
                    indexedGetter = new ListIndexedGetter();
                    sizeGetter = new ListSizeGetter();
                } else if (TypeHelper.isArray(propertyMeta.getPropertyType())) {
                    indexedGetter = new ArrayIndexedGetter();
                    sizeGetter = new ArraySizeGetter();
                } else {
                    throw new IllegalArgumentException("Unexpected elementMeta" + propertyMeta);
                }
                PropertyMeta childProperty = pm.getPropertyMeta().getPropertyClassMeta().newPropertyFinder().findProperty(DefaultPropertyNameMatcher.of("0"));
                PropertyMapping pmchildProperttMeta = pm.propertyMeta(childProperty);
                IndexedSetter setter = this.getSetter(pmchildProperttMeta);
                return new CollectionIndexFieldMapper(setter, collectionGetter, sizeGetter, indexedGetter);
            }

            private <P, C> IndexedSetter<PreparedStatement, P> getSetter(PropertyMapping<C, P, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                IndexedSetter<Object, Object> setter = null;
                IndexedSetterProperty indexedSetterProperty = pm.getColumnDefinition().lookFor(IndexedSetterProperty.class);
                if (indexedSetterProperty != null) {
                    setter = indexedSetterProperty.getIndexedSetter();
                }
                if (setter == null) {
                    setter = this.indexedSetterFactory(pm);
                }
                if (setter == null) {
                    PreparedStatementMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound("Could not find setter for " + pm + " See " + ErrorDoc.toUrl("PS_SETTER_NOT_FOUND"));
                }
                return setter;
            }

            private <P, C> IndexedSetter<PreparedStatement, P> indexedSetterFactory(PropertyMapping<C, P, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                PropertyMeta subProp;
                PropertyMapping subPropertyMapping;
                IndexedSetter<PreparedStatement, ?> subSetter;
                ObjectClassMeta ocm;
                ClassMeta<P> classMeta;
                IndexedSetter<Object, Object> setter = null;
                IndexedSetterFactoryProperty indexedSetterPropertyFactory = pm.getColumnDefinition().lookFor(IndexedSetterFactoryProperty.class);
                if (indexedSetterPropertyFactory != null) {
                    IndexedSetterFactory<?, ?> setterFactory = indexedSetterPropertyFactory.getIndexedSetterFactory();
                    setter = setterFactory.getIndexedSetter(pm);
                }
                if (setter == null) {
                    setter = this.setterFactory.getIndexedSetter(pm);
                }
                if (setter == null && (classMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)classMeta).getNumberOfProperties() == 1 && (subSetter = this.indexedSetterFactory(subPropertyMapping = pm.propertyMeta(subProp = ocm.getFirstProperty()))) != null) {
                    setter = new PreparedStatementIndexSetterOnGetter((PreparedStatementIndexSetter)subSetter, subProp.getGetter());
                }
                return setter;
            }

            private <P> MultiIndexFieldMapper<T> newFieldMapper(PropertyMapping<T, P, JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> pm) {
                return new SingleIndexFieldMapper(this.getSetter(pm), pm.getPropertyMeta().getGetter());
            }
        });
        return fields.toArray(new MultiIndexFieldMapper[0]);
    }

    private static class NullInstantiator<T>
    implements Instantiator<T, PreparedStatement> {
        private NullInstantiator() {
        }

        @Override
        public PreparedStatement newInstance(T o) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

