/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.impl.getter.ArrayResultSetGetter;
import org.sfm.jdbc.impl.getter.ArrayToListResultSetGetter;
import org.sfm.jdbc.impl.getter.BigDecimalResultSetGetter;
import org.sfm.jdbc.impl.getter.BigIntegerResultSetGetter;
import org.sfm.jdbc.impl.getter.BlobResultSetGetter;
import org.sfm.jdbc.impl.getter.BooleanResultSetGetter;
import org.sfm.jdbc.impl.getter.ByteArrayResultSetGetter;
import org.sfm.jdbc.impl.getter.ByteResultSetGetter;
import org.sfm.jdbc.impl.getter.CalendarResultSetGetter;
import org.sfm.jdbc.impl.getter.CharacterResultSetGetter;
import org.sfm.jdbc.impl.getter.ClobResultSetGetter;
import org.sfm.jdbc.impl.getter.DateResultSetGetter;
import org.sfm.jdbc.impl.getter.DoubleResultSetGetter;
import org.sfm.jdbc.impl.getter.FloatResultSetGetter;
import org.sfm.jdbc.impl.getter.InputStreamResultSetGetter;
import org.sfm.jdbc.impl.getter.IntResultSetGetter;
import org.sfm.jdbc.impl.getter.LongResultSetGetter;
import org.sfm.jdbc.impl.getter.NClobResultSetGetter;
import org.sfm.jdbc.impl.getter.NReaderResultSetGetter;
import org.sfm.jdbc.impl.getter.NStringResultSetGetter;
import org.sfm.jdbc.impl.getter.ObjectResultSetGetter;
import org.sfm.jdbc.impl.getter.ReaderResultSetGetter;
import org.sfm.jdbc.impl.getter.RefResultSetGetter;
import org.sfm.jdbc.impl.getter.RowIdResultSetGetter;
import org.sfm.jdbc.impl.getter.SQLXMLResultSetGetter;
import org.sfm.jdbc.impl.getter.ShortResultSetGetter;
import org.sfm.jdbc.impl.getter.SqlArrayResultSetGetter;
import org.sfm.jdbc.impl.getter.StringResultSetGetter;
import org.sfm.jdbc.impl.getter.TimeResultSetGetter;
import org.sfm.jdbc.impl.getter.TimestampResultSetGetter;
import org.sfm.jdbc.impl.getter.UndefinedDateResultSetGetter;
import org.sfm.jdbc.impl.getter.UrlFromStringResultSetGetter;
import org.sfm.jdbc.impl.getter.UrlResultSetGetter;
import org.sfm.map.GetterFactory;
import org.sfm.map.MapperBuildingException;
import org.sfm.map.getter.BytesUUIDGetter;
import org.sfm.map.getter.EnumUnspecifiedTypeGetter;
import org.sfm.map.getter.OrdinalEnumGetter;
import org.sfm.map.getter.StringEnumGetter;
import org.sfm.map.getter.StringUUIDGetter;
import org.sfm.map.getter.UUIDUnspecifiedTypeGetter;
import org.sfm.map.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.getter.time.JavaTimeGetterFactory;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;

public final class ResultSetGetterFactory
implements GetterFactory<ResultSet, JdbcColumnKey> {
    public static final GetterFactory<ResultSet, JdbcColumnKey> DATE_GETTER_FACTORY = new GetterFactory<ResultSet, JdbcColumnKey>(){

        @Override
        public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
            switch (key.getSqlType()) {
                case -99999: {
                    return new UndefinedDateResultSetGetter(key.getIndex());
                }
                case 93: {
                    return new TimestampResultSetGetter(key.getIndex());
                }
                case 91: {
                    return new DateResultSetGetter(key.getIndex());
                }
                case 92: {
                    return new TimeResultSetGetter(key.getIndex());
                }
            }
            return null;
        }
    };
    public static final GetterFactory<ResultSet, JdbcColumnKey> ENUM_GETTER_FACTORY = new GetterFactory<ResultSet, JdbcColumnKey>(){

        @Override
        public <P> Getter<ResultSet, P> newGetter(Type type, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
            Class enumClass = TypeHelper.toClass(type);
            return this.newEnumGetter(enumClass, key);
        }

        private <P extends Enum<P>> Getter<ResultSet, P> newEnumGetter(Class<P> type, JdbcColumnKey key) {
            int column = key.getIndex();
            switch (key.getSqlType()) {
                case -99999: {
                    return new EnumUnspecifiedTypeGetter<ResultSet, P>(new ObjectResultSetGetter(column), type);
                }
                case -6: 
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    return new OrdinalEnumGetter<ResultSet, P>(new IntResultSetGetter(column), type);
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return new StringEnumGetter<ResultSet, P>(new StringResultSetGetter(column), type);
                }
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    return new StringEnumGetter<ResultSet, P>(new NStringResultSetGetter(column), type);
                }
            }
            throw new MapperBuildingException("Incompatible type " + key.getSqlType() + " with enum");
        }
    };
    public static final int UNDEFINED = -99999;
    private static final Map<Class<?>, GetterFactory<ResultSet, JdbcColumnKey>> factoryPerType = new HashMap();
    private static final JodaTimeGetterFactory<ResultSet, JdbcColumnKey> jodaTimeGetterFactory;

    @Override
    public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter getter;
        GetterFactory<ResultSet, JdbcColumnKey> getterFactory;
        Class<?> clazz = TypeHelper.wrap(TypeHelper.toClass(genericType));
        if (Object.class.equals(clazz)) {
            return new ObjectResultSetGetter(key.getIndex());
        }
        if (key.getSqlType() == 2003) {
            if (clazz.isArray()) {
                Class<?> elementType = clazz.getComponentType();
                return this.newArrayGetter(elementType, key, columnDefinition);
            }
            if (TypeHelper.isAssignable(List.class, genericType)) {
                Type elementType = TypeHelper.getComponentTypeOfListOrArray(genericType);
                return this.newArrayListGetter(elementType, key, columnDefinition);
            }
        }
        if ((getterFactory = clazz.isEnum() ? ENUM_GETTER_FACTORY : factoryPerType.get(clazz)) == null) {
            for (Map.Entry<Class<?>, GetterFactory<ResultSet, JdbcColumnKey>> e : factoryPerType.entrySet()) {
                if (!clazz.isAssignableFrom(e.getKey())) continue;
                getterFactory = e.getValue();
                break;
            }
        }
        if ((getter = getterFactory != null ? getterFactory.newGetter(genericType, key, columnDefinition) : jodaTimeGetterFactory.newGetter(genericType, key, columnDefinition)) == null && (SQLData.class.isAssignableFrom(clazz) || key.getSqlType() == 2000)) {
            return new ObjectResultSetGetter(key.getIndex());
        }
        return getter;
    }

    private <E> Getter<ResultSet, E[]> newArrayGetter(Class<E> elementType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter elementGetter = this.newGetter((Type)elementType, new JdbcColumnKey("elt", 2), columnDefinition);
        if (elementGetter != null) {
            return new ArrayResultSetGetter<E>(key.getIndex(), elementType, elementGetter);
        }
        return null;
    }

    private <E> Getter<ResultSet, List<E>> newArrayListGetter(Type elementType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter elementGetter = this.newGetter(elementType, new JdbcColumnKey("elt", 2), columnDefinition);
        if (elementGetter != null) {
            return new ArrayToListResultSetGetter(key.getIndex(), elementGetter);
        }
        return null;
    }

    static {
        factoryPerType.put(String.class, new StringResultSetGetterFactory());
        factoryPerType.put(java.util.Date.class, DATE_GETTER_FACTORY);
        factoryPerType.put(Calendar.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Getter dateGetter = DATE_GETTER_FACTORY.newGetter((Type)((Object)java.util.Date.class), key, columnDefinition);
                if (dateGetter != null) {
                    return new CalendarResultSetGetter(dateGetter);
                }
                return null;
            }
        });
        factoryPerType.put(Date.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new DateResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Timestamp.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new TimestampResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Time.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new TimeResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Boolean.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new BooleanResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Byte.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new ByteResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Character.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new CharacterResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Short.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new ShortResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Integer.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new IntResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Long.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new LongResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Float.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new FloatResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Double.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new DoubleResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(BigInteger.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new BigIntegerResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(BigDecimal.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new BigDecimalResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(URL.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                if (key.getSqlType() == 70) {
                    return new UrlResultSetGetter(key.getIndex());
                }
                return new UrlFromStringResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(byte[].class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new ByteArrayResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(InputStream.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new InputStreamResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Blob.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new BlobResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Reader.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                switch (key.getSqlType()) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new NReaderResultSetGetter(key.getIndex());
                    }
                }
                return new ReaderResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Clob.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new ClobResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(NClob.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new NClobResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Ref.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new RefResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(RowId.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new RowIdResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(SQLXML.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new SQLXMLResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(Array.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new SqlArrayResultSetGetter(key.getIndex());
            }
        });
        factoryPerType.put(UUID.class, new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type target, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                switch (key.getSqlType()) {
                    case -99999: {
                        return new UUIDUnspecifiedTypeGetter<ResultSet>(new ObjectResultSetGetter(key.getIndex()));
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return new StringUUIDGetter<ResultSet>(new StringResultSetGetter(key.getIndex()));
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new StringUUIDGetter<ResultSet>(new NStringResultSetGetter(key.getIndex()));
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        return new BytesUUIDGetter<ResultSet>(new ByteArrayResultSetGetter(key.getIndex()));
                    }
                    case 1111: {
                        return new ObjectResultSetGetter(key.getIndex());
                    }
                }
                throw new MapperBuildingException("Incompatible type " + key.getSqlType() + " with UUID");
            }
        });
        GetterFactory<ResultSet, JdbcColumnKey> objectGetterFactory = new GetterFactory<ResultSet, JdbcColumnKey>(){

            @Override
            public <P> Getter<ResultSet, P> newGetter(Type target, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new ObjectResultSetGetter(key.getIndex());
            }
        };
        JavaTimeGetterFactory<ResultSet, JdbcColumnKey> javaTimeGetterFactory = new JavaTimeGetterFactory<ResultSet, JdbcColumnKey>(objectGetterFactory);
        factoryPerType.put(LocalDate.class, javaTimeGetterFactory);
        factoryPerType.put(LocalDateTime.class, javaTimeGetterFactory);
        factoryPerType.put(LocalTime.class, javaTimeGetterFactory);
        factoryPerType.put(OffsetDateTime.class, javaTimeGetterFactory);
        factoryPerType.put(OffsetTime.class, javaTimeGetterFactory);
        factoryPerType.put(ZonedDateTime.class, javaTimeGetterFactory);
        factoryPerType.put(Instant.class, javaTimeGetterFactory);
        factoryPerType.put(Year.class, javaTimeGetterFactory);
        factoryPerType.put(YearMonth.class, javaTimeGetterFactory);
        jodaTimeGetterFactory = new JodaTimeGetterFactory<ResultSet, JdbcColumnKey>(factoryPerType.get(java.util.Date.class));
    }

    public static final class StringResultSetGetterFactory
    implements GetterFactory<ResultSet, JdbcColumnKey> {
        @Override
        public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
            switch (key.getSqlType()) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    return new NStringResultSetGetter(key.getIndex());
                }
            }
            return new StringResultSetGetter(key.getIndex());
        }
    }
}

