/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.sfm.jdbc.MultiIndexFieldMapper;
import org.sfm.jdbc.impl.BatchQueryExecutor;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public abstract class AbstractBatchInsertQueryExecutor<T>
implements BatchQueryExecutor<T> {
    protected final String table;
    protected final String[] insertColumns;
    protected final String[] updateColumns;
    protected final String[] generatedKeys;
    protected final MultiIndexFieldMapper<T>[] multiIndexFieldMappers;

    public AbstractBatchInsertQueryExecutor(String table, String[] insertColumns, String[] updateColumns, String[] generatedKeys, MultiIndexFieldMapper<T>[] multiIndexFieldMappers) {
        this.table = table;
        this.insertColumns = insertColumns;
        this.updateColumns = updateColumns;
        this.generatedKeys = generatedKeys;
        this.multiIndexFieldMappers = multiIndexFieldMappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection connection, Collection<T> values, RowHandler<PreparedStatement> postExecute) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, values.size());
        try {
            this.bindTo(preparedStatement, values);
            preparedStatement.executeUpdate();
            postExecute.handle(preparedStatement);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private PreparedStatement prepareStatement(Connection connection, int batchSize) throws SQLException {
        StringBuilder sb = this.createQuery(batchSize);
        if (this.generatedKeys.length == 0) {
            return connection.prepareStatement(sb.toString());
        }
        return connection.prepareStatement(sb.toString(), this.generatedKeys);
    }

    private StringBuilder createQuery(int size) {
        StringBuilder sb = new StringBuilder();
        this.insertInto(sb);
        this.values(size, sb);
        if (this.updateColumns != null) {
            this.onDuplicateKeys(sb);
        }
        return sb;
    }

    protected abstract void onDuplicateKeys(StringBuilder var1);

    private void values(int size, StringBuilder sb) {
        sb.append(" VALUES");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(");
            for (int j = 0; j < this.insertColumns.length; ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(")");
        }
    }

    private void insertInto(StringBuilder sb) {
        sb.append("INSERT INTO ");
        sb.append(this.table).append("(");
        for (int j = 0; j < this.insertColumns.length; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(this.insertColumns[j]);
        }
        sb.append(")");
    }

    private void bindTo(PreparedStatement preparedStatement, Collection<T> values) throws Exception {
        int i = 0;
        for (T value : values) {
            for (MultiIndexFieldMapper<T> multiIndexFieldMapper : this.multiIndexFieldMappers) {
                multiIndexFieldMapper.map(preparedStatement, value, i);
                ++i;
            }
        }
    }
}

