/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sfm.jdbc.Crud;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.QueryPreparer;
import org.sfm.jdbc.impl.KeyTupleQueryPreparer;
import org.sfm.map.Mapper;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public final class DefaultCrud<T, K>
implements Crud<T, K> {
    protected final QueryPreparer<T> insertQueryPreparer;
    protected final QueryPreparer<T> updateQueryPreparer;
    protected final QueryPreparer<K> selectQueryPreparer;
    protected final QueryPreparer<K> deleteQueryPreparer;
    protected final QueryPreparer<T> upsertQueryPreparer;
    protected final KeyTupleQueryPreparer<K> keyTupleQueryPreparer;
    protected final JdbcMapper<T> selectQueryMapper;
    protected final JdbcMapper<K> keyMapper;
    protected final String table;
    protected final boolean hasGeneratedKeys;

    public DefaultCrud(QueryPreparer<T> insertQueryPreparer, QueryPreparer<T> updateQueryPreparer, QueryPreparer<K> selectQueryPreparer, QueryPreparer<T> upsertQueryPreparer, KeyTupleQueryPreparer<K> keyTupleQueryPreparer, JdbcMapper<T> selectQueryMapper, QueryPreparer<K> deleteQueryPreparer, JdbcMapper<K> keyMapper, String table, boolean hasGeneratedKeys) {
        this.insertQueryPreparer = insertQueryPreparer;
        this.updateQueryPreparer = updateQueryPreparer;
        this.selectQueryPreparer = selectQueryPreparer;
        this.upsertQueryPreparer = upsertQueryPreparer;
        this.keyTupleQueryPreparer = keyTupleQueryPreparer;
        this.deleteQueryPreparer = deleteQueryPreparer;
        this.selectQueryMapper = selectQueryMapper;
        this.keyMapper = keyMapper;
        this.table = table;
        this.hasGeneratedKeys = hasGeneratedKeys;
    }

    @Override
    public void create(Connection connection, T value) throws SQLException {
        this.create(connection, value, null);
    }

    @Override
    public void create(Connection connection, Collection<T> values) throws SQLException {
        this.create(connection, values, (RowHandler)null);
    }

    @Override
    public <RH extends RowHandler<? super K>> RH create(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparer(connection, value, keyConsumer, this.insertQueryPreparer);
    }

    @Override
    public <RH extends RowHandler<? super K>> RH create(Connection connection, Collection<T> values, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparerInBatchMode(connection, values, keyConsumer, this.insertQueryPreparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Connection connection, K key) throws SQLException {
        block9: {
            PreparedStatement preparedStatement = this.selectQueryPreparer.prepare(connection).bind(key);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block9;
            T t = this.selectQueryMapper.map(resultSet);
            return t;
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RH extends RowHandler<? super T>> RH read(Connection connection, Collection<K> keys, RH rowHandler) throws SQLException {
        RH RH;
        PreparedStatement preparedStatement = this.keyTupleQueryPreparer.prepareStatement("SELECT * FROM " + this.table + " WHERE ", connection, keys.size());
        try {
            this.keyTupleQueryPreparer.bindTo(keys, preparedStatement, 0);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                rowHandler.handle(this.selectQueryMapper.map(resultSet));
            }
            RH = rowHandler;
        }
        catch (Exception e) {
            RowHandler rowHandler2 = (RowHandler)ErrorHelper.rethrow(e);
            return (RH)rowHandler2;
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
        return RH;
    }

    @Override
    public void update(Connection connection, T value) throws SQLException {
        this.executeQueryPreparer(connection, value, null, this.updateQueryPreparer);
    }

    @Override
    public void update(Connection connection, Collection<T> values) throws SQLException {
        this.executeQueryPreparerInBatchMode(connection, values, null, this.updateQueryPreparer);
    }

    @Override
    public void delete(Connection connection, K key) throws SQLException {
        this.executeQueryPreparer(connection, key, null, this.deleteQueryPreparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection connection, List<K> keys) throws SQLException {
        PreparedStatement preparedStatement = this.keyTupleQueryPreparer.prepareStatement("DELETE FROM " + this.table + " WHERE ", connection, keys.size());
        try {
            this.keyTupleQueryPreparer.bindTo(keys, preparedStatement, 0);
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void createOrUpdate(Connection connection, T value) throws SQLException {
        this.createOrUpdate(connection, value, null);
    }

    @Override
    public void createOrUpdate(Connection connection, Collection<T> values) throws SQLException {
        this.createOrUpdate(connection, values, (RowHandler)null);
    }

    @Override
    public <RH extends RowHandler<? super K>> RH createOrUpdate(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparer(connection, value, keyConsumer, this.upsertQueryPreparer);
    }

    @Override
    public <RH extends RowHandler<? super K>> RH createOrUpdate(Connection connection, Collection<T> values, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparerInBatchMode(connection, values, keyConsumer, this.upsertQueryPreparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RH extends RowHandler<? super K>> RH executeQueryPreparerInBatchMode(Connection connection, Collection<T> values, RH keyConsumer, QueryPreparer<T> queryPreparer) throws SQLException {
        block13: {
            Iterator<Object> iterator;
            PreparedStatement preparedStatement = queryPreparer.prepareStatement(connection);
            try {
                Mapper<PreparedStatement, PreparedStatement> mapper = queryPreparer.mapper();
                for (T value : values) {
                    mapper.mapTo((PreparedStatement)value, preparedStatement, null);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                if (this.hasGeneratedKeys && keyConsumer != null) {
                    this.handleGeneratedKeys(keyConsumer, preparedStatement);
                }
                iterator = keyConsumer;
            }
            catch (Exception e) {
                ErrorHelper.rethrow(e);
                break block13;
            }
            finally {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            return (RH)iterator;
        }
        return keyConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RH extends RowHandler<? super K>, QPT> RH executeQueryPreparer(Connection connection, QPT value, RH keyConsumer, QueryPreparer<QPT> queryPreparer) throws SQLException {
        PreparedStatement preparedStatement = queryPreparer.prepare(connection).bind(value);
        preparedStatement.executeUpdate();
        if (this.hasGeneratedKeys && keyConsumer != null) {
            this.handleGeneratedKeys(keyConsumer, preparedStatement);
        }
        RH RH = keyConsumer;
        return RH;
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGeneratedKeys(RowHandler<? super K> keyConsumer, PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet keys = preparedStatement.getGeneratedKeys();){
            while (keys.next()) {
                try {
                    keyConsumer.handle(this.keyMapper.map(keys));
                }
                catch (Exception e) {
                    ErrorHelper.rethrow(e);
                }
            }
        }
    }
}

