/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.impl.ResultSetEnumarable;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.impl.DiscriminatorEnumerable;
import org.sfm.map.mapper.AbstractEnumarableDelegateMapper;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuple3;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.Predicate;
import org.sfm.utils.conv.Converter;

public final class DiscriminatorJdbcMapper<T>
extends AbstractEnumarableDelegateMapper<ResultSet, ResultSet, T, SQLException>
implements JdbcMapper<T> {
    private final String discriminatorColumn;
    private final List<Tuple2<Predicate<String>, JdbcMapper<T>>> mappers;

    public DiscriminatorJdbcMapper(String discriminatorColumn, List<Tuple2<Predicate<String>, JdbcMapper<T>>> mappers, RowHandlerErrorHandler rowHandlerErrorHandler) {
        super(rowHandlerErrorHandler);
        this.discriminatorColumn = discriminatorColumn;
        this.mappers = mappers;
    }

    protected JdbcMapper<T> getMapper(ResultSet rs) throws MappingException {
        String value = this.getDiscriminatorValue(rs);
        for (Tuple2<Predicate<String>, JdbcMapper<T>> tm : this.mappers) {
            if (!tm.first().test(value)) continue;
            return tm.second();
        }
        throw new MappingException("No jdbcMapper found for " + this.discriminatorColumn + " = " + value);
    }

    private String getDiscriminatorValue(ResultSet rs) {
        try {
            return rs.getString(this.discriminatorColumn);
        }
        catch (SQLException e) {
            return (String)ErrorHelper.rethrow(e);
        }
    }

    protected DiscriminatorEnumerable<ResultSet, T> newEnumarableOfT(ResultSet rs) throws SQLException {
        Tuple3[] mapperDiscriminators = new Tuple3[this.mappers.size()];
        for (int i = 0; i < mapperDiscriminators.length; ++i) {
            Tuple2<Predicate<String>, JdbcMapper<T>> mapper = this.mappers.get(i);
            DiscriminatorPredicate discriminatorPredicate = new DiscriminatorPredicate(this.discriminatorColumn, mapper.first());
            mapperDiscriminators[i] = new Tuple3<DiscriminatorPredicate, JdbcMapper<T>, MappingContext<ResultSet>>(discriminatorPredicate, mapper.second(), mapper.second().newMappingContext(rs));
        }
        return new DiscriminatorEnumerable(mapperDiscriminators, new ResultSetEnumarable(rs), new ErrorMessageConverter(this.discriminatorColumn));
    }

    public String toString() {
        return "DiscriminatorJdbcMapper{discriminatorColumn='" + this.discriminatorColumn + '\'' + ", mappers=" + this.mappers + '}';
    }

    @Override
    public MappingContext<? super ResultSet> newMappingContext(ResultSet rs) throws SQLException {
        return this.getMapper(rs).newMappingContext(rs);
    }

    private static class ErrorMessageConverter
    implements Converter<ResultSet, String> {
        private final String discriminatorColumn;

        private ErrorMessageConverter(String discriminatorColumn) {
            this.discriminatorColumn = discriminatorColumn;
        }

        @Override
        public String convert(ResultSet in) throws Exception {
            return " column " + this.discriminatorColumn + " = " + in.getObject(this.discriminatorColumn);
        }
    }

    private static class DiscriminatorPredicate
    implements Predicate<ResultSet> {
        private final String discriminatorColumn;
        private final Predicate<String> predicate;

        public DiscriminatorPredicate(String discriminatorColumn, Predicate<String> predicate) {
            this.discriminatorColumn = discriminatorColumn;
            this.predicate = predicate;
        }

        @Override
        public boolean test(ResultSet resultSet) {
            try {
                return this.predicate.test(resultSet.getString(this.discriminatorColumn));
            }
            catch (SQLException e) {
                ErrorHelper.rethrow(e);
                return false;
            }
        }
    }
}

