/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.sfm.jdbc.QueryBinder;
import org.sfm.jdbc.impl.MapperQueryPreparer;
import org.sfm.utils.ErrorHelper;

public class MapperQueryBinder<T>
implements QueryBinder<T> {
    private final MapperQueryPreparer<T> queryPreparer;
    private final Connection connection;

    public MapperQueryBinder(MapperQueryPreparer<T> queryPreparer, Connection connection) {
        this.queryPreparer = queryPreparer;
        this.connection = connection;
    }

    @Override
    public PreparedStatement bind(T value) throws SQLException {
        PreparedStatement preparedStatement = this.queryPreparer.prepareStatement(this.connection);
        try {
            this.queryPreparer.mapper().mapTo((PreparedStatement)value, preparedStatement, null);
            return preparedStatement;
        }
        catch (Exception t) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorHelper.rethrow(t);
            return null;
        }
    }

    @Override
    public void bindTo(T value, PreparedStatement ps) throws SQLException {
        try {
            this.queryPreparer.mapper().mapTo((PreparedStatement)value, ps, null);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
    }
}

