/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import org.sfm.jdbc.Crud;
import org.sfm.jdbc.JdbcMapperFactory;
import org.sfm.jdbc.PreparedStatementMapperBuilder;
import org.sfm.jdbc.QueryPreparer;
import org.sfm.jdbc.impl.BatchQueryExecutor;
import org.sfm.jdbc.impl.ColumnMeta;
import org.sfm.jdbc.impl.CrudMeta;
import org.sfm.jdbc.impl.DefaultCrud;
import org.sfm.jdbc.impl.MultiRowsBatchInsertCrud;
import org.sfm.jdbc.impl.PostgresqlBatchInsertQueryExecutor;
import org.sfm.jdbc.named.NamedSqlQuery;
import org.sfm.reflect.meta.ClassMeta;

public class PostgresqlCrudFactory {
    public static <T, K> Crud<T, K> newInstance(ClassMeta<T> target, ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory, DefaultCrud<T, K> defaultCrud) throws SQLException {
        return new MultiRowsBatchInsertCrud<T, K>(defaultCrud, PostgresqlCrudFactory.buildBatchInsert(target, crudMeta, jdbcMapperFactory, false), PostgresqlCrudFactory.buildBatchInsert(target, crudMeta, jdbcMapperFactory, true));
    }

    private static <T, K> BatchQueryExecutor<T> buildBatchInsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory, boolean onDuplicateKeyUpdate) throws SQLException {
        ArrayList<String> generatedKeys = new ArrayList<String>();
        ArrayList<String> insertColumns = new ArrayList<String>();
        ArrayList<String> updateColumns = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        PreparedStatementMapperBuilder<T> statementMapperBuilder = jdbcMapperFactory.from(target);
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            String columnName = cm.getColumn();
            if (cm.isGenerated()) {
                generatedKeys.add(columnName);
            } else {
                insertColumns.add(columnName);
                statementMapperBuilder.addColumn(columnName);
            }
            if (!cm.isKey()) {
                updateColumns.add(columnName);
                continue;
            }
            keys.add(columnName);
        }
        PostgresqlBatchInsertQueryExecutor<T> queryExecutor = new PostgresqlBatchInsertQueryExecutor<T>(crudMeta.getTable(), insertColumns.toArray(new String[0]), onDuplicateKeyUpdate ? updateColumns.toArray(new String[0]) : null, generatedKeys.toArray(new String[0]), keys.toArray(new String[0]), statementMapperBuilder.buildIndexFieldMappers());
        return queryExecutor;
    }

    public static <T, K> QueryPreparer<T> buildUpsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) {
        ArrayList<String> generatedKeys = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(crudMeta.getTable()).append("(");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isGenerated()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(cm.getColumn());
                first = false;
                continue;
            }
            generatedKeys.add(cm.getColumn());
        }
        sb.append(") VALUES(");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (cm.isGenerated()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append("?");
            first = false;
        }
        sb.append(") ON CONFLICT (");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isKey()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getColumn());
            first = false;
        }
        sb.append(") DO UPDATE SET ");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (cm.isKey()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getColumn());
            sb.append(" = EXCLUDED.").append(cm.getColumn());
            first = false;
        }
        return jdbcMapperFactory.from(target).to(NamedSqlQuery.parse(sb), generatedKeys.toArray(new String[0]));
    }
}

