/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.impl.convert.CalendarToTimestampConverter;
import org.sfm.jdbc.impl.convert.UtilDateToTimestampConverter;
import org.sfm.jdbc.impl.convert.time.JavaInstantToTimestampConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalDateTimeToTimestampConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalDateToDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaLocalTimeToTimeConverter;
import org.sfm.jdbc.impl.convert.time.JavaOffsetDateTimeToTimestampConverter;
import org.sfm.jdbc.impl.convert.time.JavaOffsetTimeToTimeConverter;
import org.sfm.jdbc.impl.convert.time.JavaYearMonthToDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaYearToDateConverter;
import org.sfm.jdbc.impl.convert.time.JavaZonedDateTimeToTimestampConverter;
import org.sfm.jdbc.impl.setter.ArrayPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.BigDecimalPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.BlobPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.BooleanPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.BooleanPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.BytePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.BytePreparedStatementSetter;
import org.sfm.jdbc.impl.setter.BytesPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.CharacterPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.CharacterPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.ClobPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.ConvertDelegateIndexSetter;
import org.sfm.jdbc.impl.setter.DatePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.DoublePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.DoublePreparedStatementSetter;
import org.sfm.jdbc.impl.setter.FloatPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.FloatPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.InputStreamPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.IntegerPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.IntegerPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.JodaTimePreparedStatementFactory;
import org.sfm.jdbc.impl.setter.LongPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.LongPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.NClobPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.ObjectPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.OrdinalEnumPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.PreparedStatementSetterImpl;
import org.sfm.jdbc.impl.setter.ReaderPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.RefPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.RowIdPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.SQLXMLPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.ShortPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.ShortPreparedStatementSetter;
import org.sfm.jdbc.impl.setter.StringEnumPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.StringPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.TimePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.TimestampPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.URLPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.UUIDBinaryPreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.UUIDStringPreparedStatementIndexSetter;
import org.sfm.map.column.time.JavaTimeHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.IndexedSetter;
import org.sfm.reflect.IndexedSetterFactory;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.TypeHelper;

public class PreparedStatementSetterFactory
implements SetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>>,
IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> {
    private final Map<Class<?>, Factory> factoryPerClass = new HashMap();
    private final Factory jodaTimeFieldMapperToSourceFactory;
    private final Factory javaTimeFieldMapperToSourceFactory;

    public PreparedStatementSetterFactory() {
        this.factoryPerClass.put(Boolean.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new BooleanPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Boolean.class, this.factoryPerClass.get(Boolean.TYPE));
        this.factoryPerClass.put(Byte.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new BytePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Byte.class, this.factoryPerClass.get(Byte.TYPE));
        this.factoryPerClass.put(Character.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new CharacterPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Character.class, this.factoryPerClass.get(Character.TYPE));
        this.factoryPerClass.put(Short.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ShortPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Short.class, this.factoryPerClass.get(Short.TYPE));
        this.factoryPerClass.put(Integer.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new IntegerPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new LongPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new FloatPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new DoublePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new StringPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Date.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ConvertDelegateIndexSetter<Date, Timestamp>(new TimestampPreparedStatementIndexSetter(), new UtilDateToTimestampConverter());
            }
        });
        this.factoryPerClass.put(Timestamp.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new TimestampPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(java.sql.Date.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new DatePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Time.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new TimePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Calendar.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ConvertDelegateIndexSetter<Calendar, Timestamp>(new TimestampPreparedStatementIndexSetter(), new CalendarToTimestampConverter());
            }
        });
        this.factoryPerClass.put(URL.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new URLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Ref.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new RefPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new BigDecimalPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Array.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ArrayPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(byte[].class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new BytesPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(NClob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new NClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(RowId.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new RowIdPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Blob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new BlobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Clob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(InputStream.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new InputStreamPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Reader.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new ReaderPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(SQLXML.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                return new SQLXMLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(UUID.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                switch (pm.getColumnKey().getSqlType()) {
                    case -4: 
                    case -3: 
                    case -2: {
                        return new UUIDBinaryPreparedStatementIndexSetter();
                    }
                    case 1111: {
                        return new ObjectPreparedStatementIndexSetter();
                    }
                }
                return new UUIDStringPreparedStatementIndexSetter();
            }
        });
        this.jodaTimeFieldMapperToSourceFactory = new JodaTimePreparedStatementFactory();
        this.javaTimeFieldMapperToSourceFactory = new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), LocalDateTime.class)) {
                    return new ConvertDelegateIndexSetter<LocalDateTime, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JavaLocalDateTimeToTimestampConverter(JavaTimeHelper.getZoneIdOrDefault(pm.getColumnDefinition())));
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), LocalDate.class)) {
                    return new ConvertDelegateIndexSetter<LocalDate, java.sql.Date>(new DatePreparedStatementIndexSetter(), new JavaLocalDateToDateConverter(JavaTimeHelper.getZoneIdOrDefault(pm.getColumnDefinition())));
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), LocalTime.class)) {
                    return new ConvertDelegateIndexSetter<LocalTime, Time>(new TimePreparedStatementIndexSetter(), new JavaLocalTimeToTimeConverter(JavaTimeHelper.getZoneIdOrDefault(pm.getColumnDefinition())));
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), Instant.class)) {
                    return new ConvertDelegateIndexSetter<Instant, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JavaInstantToTimestampConverter());
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), ZonedDateTime.class)) {
                    return new ConvertDelegateIndexSetter<ZonedDateTime, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JavaZonedDateTimeToTimestampConverter());
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), OffsetDateTime.class)) {
                    return new ConvertDelegateIndexSetter<OffsetDateTime, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JavaOffsetDateTimeToTimestampConverter());
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), OffsetTime.class)) {
                    return new ConvertDelegateIndexSetter<OffsetTime, Time>(new TimePreparedStatementIndexSetter(), new JavaOffsetTimeToTimeConverter());
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), YearMonth.class)) {
                    return new ConvertDelegateIndexSetter<YearMonth, java.sql.Date>(new DatePreparedStatementIndexSetter(), new JavaYearMonthToDateConverter(JavaTimeHelper.getZoneIdOrDefault(pm.getColumnDefinition())));
                }
                if (TypeHelper.isClass(pm.getPropertyMeta().getPropertyType(), Year.class)) {
                    return new ConvertDelegateIndexSetter<Year, java.sql.Date>(new DatePreparedStatementIndexSetter(), new JavaYearToDateConverter(JavaTimeHelper.getZoneIdOrDefault(pm.getColumnDefinition())));
                }
                return null;
            }
        };
    }

    @Override
    public <P> Setter<PreparedStatement, P> getSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
        int columnIndex = pm.getColumnKey().getIndex();
        Type type = pm.getPropertyMeta().getPropertyType();
        Class<?> clazz = TypeHelper.toBoxedClass(type);
        if (Boolean.class.equals(clazz)) {
            return new BooleanPreparedStatementSetter(columnIndex);
        }
        if (Byte.class.equals(clazz)) {
            return new BytePreparedStatementSetter(columnIndex);
        }
        if (Character.class.equals(clazz)) {
            return new CharacterPreparedStatementSetter(columnIndex);
        }
        if (Short.class.equals(clazz)) {
            return new ShortPreparedStatementSetter(columnIndex);
        }
        if (Integer.class.equals(clazz)) {
            return new IntegerPreparedStatementSetter(columnIndex);
        }
        if (Long.class.equals(clazz)) {
            return new LongPreparedStatementSetter(columnIndex);
        }
        if (Double.class.equals(clazz)) {
            return new DoublePreparedStatementSetter(columnIndex);
        }
        if (Float.class.equals(clazz)) {
            return new FloatPreparedStatementSetter(columnIndex);
        }
        IndexedSetter setter = this.getIndexedSetter(pm);
        if (setter != null) {
            return new PreparedStatementSetterImpl(columnIndex, setter);
        }
        return null;
    }

    @Override
    public <T> IndexedSetter<PreparedStatement, T> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> arg) {
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        IndexedSetter<PreparedStatement, Enum> setter = null;
        Factory setterFactory = this.factoryPerClass.get(TypeHelper.toClass(propertyType));
        if (setterFactory != null) {
            setter = setterFactory.getIndexedSetter(arg);
        }
        if (TypeHelper.isEnum(propertyType)) {
            switch (arg.getColumnKey().getSqlType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    setter = new OrdinalEnumPreparedStatementIndexSetter();
                    break;
                }
                default: {
                    setter = new StringEnumPreparedStatementIndexSetter();
                }
            }
        }
        if (setter == null && JodaTimeClasses.isJoda(propertyType)) {
            setter = this.jodaTimeFieldMapperToSourceFactory.getIndexedSetter(arg);
        }
        if (setter == null) {
            setter = this.javaTimeFieldMapperToSourceFactory.getIndexedSetter(arg);
        }
        if (setter == null && TypeHelper.isAssignable(SQLData.class, propertyType)) {
            setter = new ObjectPreparedStatementIndexSetter();
        }
        return setter;
    }

    public static interface Factory
    extends IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> {
    }
}

