/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.convert.time;

import java.sql.Date;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.ZoneId;
import org.sfm.utils.conv.Converter;

public class JavaYearToDateConverter
implements Converter<Year, Date> {
    private final ZoneId zoneId;

    public JavaYearToDateConverter(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public Date convert(Year in) throws Exception {
        if (in == null) {
            return null;
        }
        return new Date(in.atMonthDay(MonthDay.of(Month.JANUARY, 1)).atStartOfDay(this.zoneId).toInstant().toEpochMilli());
    }
}

