/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.Getter;

public final class ArrayToListResultSetGetter<E>
implements Getter<ResultSet, List<E>> {
    private final int column;
    private final Getter<ResultSet, E> elementGetter;

    public ArrayToListResultSetGetter(int column, Getter<ResultSet, E> elementGetter) {
        this.column = column;
        this.elementGetter = elementGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> get(ResultSet target) throws Exception {
        Array array = target.getArray(this.column);
        ArrayList<E> list = new ArrayList<E>();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                list.add(this.elementGetter.get(rs));
            }
        }
        return list;
    }

    public String toString() {
        return "ArrayToListResultSetGetter{column=" + this.column + ", elementGetter=" + this.elementGetter + '}';
    }
}

