/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.BooleanGetter;

public final class BooleanResultSetGetter
implements BooleanGetter<ResultSet>,
Getter<ResultSet, Boolean> {
    private final int column;

    public BooleanResultSetGetter(int column) {
        this.column = column;
    }

    @Override
    public boolean getBoolean(ResultSet target) throws SQLException {
        return target.getBoolean(this.column);
    }

    @Override
    public Boolean get(ResultSet target) throws Exception {
        boolean b = this.getBoolean(target);
        if (!b && target.wasNull()) {
            return null;
        }
        return b;
    }

    public String toString() {
        return "BooleanResultSetGetter{column=" + this.column + '}';
    }
}

