/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.FloatGetter;

public final class FloatResultSetGetter
implements FloatGetter<ResultSet>,
Getter<ResultSet, Float> {
    private final int column;

    public FloatResultSetGetter(int column) {
        this.column = column;
    }

    @Override
    public float getFloat(ResultSet target) throws SQLException {
        return target.getFloat(this.column);
    }

    @Override
    public Float get(ResultSet target) throws Exception {
        float f = this.getFloat(target);
        if (f == 0.0f && target.wasNull()) {
            return null;
        }
        return Float.valueOf(f);
    }

    public String toString() {
        return "FloatResultSetGetter{column=" + this.column + '}';
    }
}

