/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.sfm.reflect.Getter;

public class UndefinedDateResultSetGetter
implements Getter<ResultSet, Date> {
    private final int column;

    public UndefinedDateResultSetGetter(int column) {
        this.column = column;
    }

    @Override
    public Date get(ResultSet target) throws SQLException {
        Object o = target.getObject(this.column);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        throw new SQLException("Expected date, cannot convert " + o + " to date");
    }

    public String toString() {
        return "UndefinedDateResultSetGetter{column=" + this.column + '}';
    }
}

