/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.setter;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.impl.PreparedStatementSetterFactory;
import org.sfm.jdbc.impl.convert.joda.JodaDateTimeToTimestampConverter;
import org.sfm.jdbc.impl.convert.joda.JodaInstantToTimestampConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalDateTimeToTimestampConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalDateToDateConverter;
import org.sfm.jdbc.impl.convert.joda.JodaLocalTimeToTimeConverter;
import org.sfm.jdbc.impl.setter.ConvertDelegateIndexSetter;
import org.sfm.jdbc.impl.setter.DatePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.TimePreparedStatementIndexSetter;
import org.sfm.jdbc.impl.setter.TimestampPreparedStatementIndexSetter;
import org.sfm.map.column.joda.JodaHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;

public class JodaTimePreparedStatementFactory
implements PreparedStatementSetterFactory.Factory {
    public <P> PreparedStatementIndexSetter<P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
        if (JodaTimeClasses.isJodaDateTime(pm.getPropertyMeta().getPropertyType())) {
            return new ConvertDelegateIndexSetter<DateTime, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JodaDateTimeToTimestampConverter());
        }
        if (JodaTimeClasses.isJodaLocalDateTime(pm.getPropertyMeta().getPropertyType())) {
            return new ConvertDelegateIndexSetter<LocalDateTime, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JodaLocalDateTimeToTimestampConverter(JodaHelper.getDateTimeZoneOrDefault(pm.getColumnDefinition())));
        }
        if (JodaTimeClasses.isJodaLocalDate(pm.getPropertyMeta().getPropertyType())) {
            return new ConvertDelegateIndexSetter<LocalDate, Date>(new DatePreparedStatementIndexSetter(), new JodaLocalDateToDateConverter());
        }
        if (JodaTimeClasses.isJodaLocalTime(pm.getPropertyMeta().getPropertyType())) {
            return new ConvertDelegateIndexSetter<LocalTime, Time>(new TimePreparedStatementIndexSetter(), new JodaLocalTimeToTimeConverter(JodaHelper.getDateTimeZoneOrDefault(pm.getColumnDefinition())));
        }
        if (JodaTimeClasses.isJodaInstant(pm.getPropertyMeta().getPropertyType())) {
            return new ConvertDelegateIndexSetter<Instant, Timestamp>(new TimestampPreparedStatementIndexSetter(), new JodaInstantToTimestampConverter());
        }
        return null;
    }
}

