/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.PropertyWithGetter;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.ConstantValueProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.KeySourceGetter;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.ContextualMapper;
import org.sfm.map.mapper.MapperImpl;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.mapper.PropertyMappingsBuilder;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.ScoredGetter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.ConstantGetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ObjectPropertyMeta;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;

public abstract class AbstractWriterBuilder<S, T, K extends FieldKey<K>, B extends AbstractWriterBuilder<S, T, K, B>> {
    private final ReflectionService reflectionService;
    protected final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final PropertyMappingsBuilder<T, K, FieldMapperColumnDefinition<K>> propertyMappingsBuilder;
    protected final ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory;
    protected final ClassMeta<T> classMeta;
    private final Class<S> sourceClass;
    private int currentIndex = this.getStartingIndex();

    public AbstractWriterBuilder(ClassMeta<T> classMeta, Class<S> sourceClass, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory) {
        this.sourceClass = sourceClass;
        this.fieldAppenderFactory = fieldAppenderFactory;
        this.reflectionService = classMeta.getReflectionService();
        this.mapperConfig = mapperConfig;
        this.propertyMappingsBuilder = new PropertyMappingsBuilder(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler(), new PropertyWithGetter());
        this.classMeta = classMeta;
    }

    public B addColumn(String column) {
        return this.addColumn((K)column, FieldMapperColumnDefinition.identity());
    }

    public B addColumn(String column, ColumnProperty ... properties) {
        FieldMapperColumnDefinition columnDefinition = FieldMapperColumnDefinition.of(properties);
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, ColumnProperty ... properties) {
        return this.addColumn(key, (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties));
    }

    public B addColumn(String column, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        FieldMapperColumnDefinition<K> composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = composedDefinition.rename(key);
        if (composedDefinition.has(ConstantValueProperty.class)) {
            ConstantValueProperty staticValueProperty = composedDefinition.lookFor(ConstantValueProperty.class);
            ObjectPropertyMeta meta = new ObjectPropertyMeta(((FieldKey)key).getName(), this.reflectionService, staticValueProperty.getType(), ScoredGetter.of(new ConstantGetter(staticValueProperty.getValue()), 1), null);
            this.propertyMappingsBuilder.addProperty(key, columnDefinition, meta);
        } else {
            this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
        }
        return (B)this;
    }

    public Mapper<T, S> mapper() {
        Mapper<T, S> mapper;
        final ArrayList<FieldMapper<FieldMapper, S>> mappers = new ArrayList<FieldMapper<FieldMapper, S>>();
        final MappingContextFactoryBuilder mappingContextFactoryBuilder = new MappingContextFactoryBuilder(new KeySourceGetter<K, T>(){

            @Override
            public Object getValue(K key, T source) throws SQLException {
                throw new UnsupportedOperationException();
            }
        });
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            @Override
            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
                AbstractWriterBuilder.this.preFieldProcess(mappers, pm);
                FieldMapper fieldMapper = AbstractWriterBuilder.this.fieldAppenderFactory.newFieldMapper(pm, mappingContextFactoryBuilder, AbstractWriterBuilder.this.mapperConfig.mapperBuilderErrorHandler());
                mappers.add(fieldMapper);
                AbstractWriterBuilder.this.postFieldProcess(mappers, pm);
            }
        });
        this.postMapperProcess(mappers);
        FieldMapper[] fields = mappers.toArray(new FieldMapper[0]);
        Instantiator<T, S> instantiator = this.getInstantiator();
        if (mappers.size() < 256) {
            try {
                mapper = this.reflectionService.getAsmFactory().createMapper(this.getKeys(), fields, new FieldMapper[0], instantiator, TypeHelper.toClass(this.classMeta.getType()), this.sourceClass);
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (Mapper)ErrorHelper.rethrow(e);
                }
                mapper = new MapperImpl<S, T>(fields, new FieldMapper[0], instantiator);
            }
        } else {
            mapper = new MapperImpl<T, S>(fields, new FieldMapper[0], instantiator);
        }
        return new ContextualMapper<T, S>(mapper, mappingContextFactoryBuilder.newFactory());
    }

    protected void postMapperProcess(List<FieldMapper<T, S>> mappers) {
    }

    protected void postFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
    }

    protected void preFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
    }

    protected int getStartingIndex() {
        return 0;
    }

    protected abstract Instantiator<T, S> getInstantiator();

    protected abstract K newKey(String var1, int var2, FieldMapperColumnDefinition<K> var3);

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new FieldKey[0]);
    }
}

