/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map;

import org.sfm.utils.Asserts;

public abstract class FieldKey<K extends FieldKey<K>> {
    protected final String name;
    protected final int index;
    protected final K parent;

    protected FieldKey(String name, int index) {
        this.name = Asserts.requireNonNull("name", name);
        this.index = index;
        this.parent = null;
    }

    protected FieldKey(String name, int index, K parent) {
        this.name = Asserts.requireNonNull("name", name);
        this.index = index;
        this.parent = parent;
    }

    public final K getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean isAlias() {
        return this.parent != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldKey fieldKey = (FieldKey)o;
        if (this.index != fieldKey.index) {
            return false;
        }
        return this.name.equals(fieldKey.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public abstract K alias(String var1);
}

