/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map;

import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapperErrorHandler;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.error.RethrowFieldMapperErrorHandler;
import org.sfm.map.error.RethrowMapperBuilderErrorHandler;
import org.sfm.map.error.RethrowRowHandlerErrorHandler;
import org.sfm.map.impl.IdentityFieldMapperColumnDefinitionProvider;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.ColumnDefinitionProvider;
import org.sfm.map.mapper.DefaultPropertyNameMatcherFactory;
import org.sfm.reflect.meta.PropertyNameMatcherFactory;
import org.sfm.utils.Asserts;

public final class MapperConfig<K extends FieldKey<K>, CD extends ColumnDefinition<K, CD>> {
    public static final int NO_ASM_MAPPER_THRESHOLD = 792;
    public static final int MAX_METHOD_SIZE = 128;
    private final ColumnDefinitionProvider<CD, K> columnDefinitions;
    private final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final boolean failOnAsm;
    private final int asmMapperNbFieldsLimit;
    private final FieldMapperErrorHandler<K> fieldMapperErrorHandler;
    private final RowHandlerErrorHandler rowHandlerErrorHandler;
    private final int maxMethodSize;

    public static <K extends FieldKey<K>> MapperConfig<K, FieldMapperColumnDefinition<K>> fieldMapperConfig() {
        return new MapperConfig(new IdentityFieldMapperColumnDefinitionProvider(), DefaultPropertyNameMatcherFactory.DEFAULT, new RethrowMapperBuilderErrorHandler(), false, 792, new RethrowFieldMapperErrorHandler(), new RethrowRowHandlerErrorHandler(), 128);
    }

    public static <K extends FieldKey<K>, CD extends ColumnDefinition<K, CD>> MapperConfig<K, CD> config(ColumnDefinitionProvider<CD, K> columnDefinitionProvider) {
        return new MapperConfig<K, CD>(columnDefinitionProvider, DefaultPropertyNameMatcherFactory.DEFAULT, new RethrowMapperBuilderErrorHandler(), false, 792, new RethrowFieldMapperErrorHandler(), new RethrowRowHandlerErrorHandler(), 128);
    }

    private MapperConfig(ColumnDefinitionProvider<CD, K> columnDefinitions, PropertyNameMatcherFactory propertyNameMatcherFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler, boolean failOnAsm, int asmMapperNbFieldsLimit, FieldMapperErrorHandler<K> fieldMapperErrorHandler, RowHandlerErrorHandler rowHandlerErrorHandler, int maxMethodSize) {
        this.columnDefinitions = columnDefinitions;
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.failOnAsm = failOnAsm;
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        this.rowHandlerErrorHandler = rowHandlerErrorHandler;
        this.maxMethodSize = maxMethodSize;
    }

    public ColumnDefinitionProvider<CD, K> columnDefinitions() {
        return this.columnDefinitions;
    }

    public PropertyNameMatcherFactory propertyNameMatcherFactory() {
        return this.propertyNameMatcherFactory;
    }

    public MapperBuilderErrorHandler mapperBuilderErrorHandler() {
        return this.mapperBuilderErrorHandler;
    }

    public boolean failOnAsm() {
        return this.failOnAsm;
    }

    public int asmMapperNbFieldsLimit() {
        return this.asmMapperNbFieldsLimit;
    }

    public MapperConfig<K, CD> columnDefinitions(ColumnDefinitionProvider<CD, K> columnDefinitions) {
        Asserts.requireNonNull("columnDefinitions", columnDefinitions);
        return new MapperConfig<K, CD>(columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        return new MapperConfig<K, CD>(this.columnDefinitions, Asserts.requireNonNull("propertyNameMatcherFactory", propertyNameMatcherFactory), this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, Asserts.requireNonNull("mapperBuilderErrorHandler", mapperBuilderErrorHandler), this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> failOnAsm(boolean failOnAsm) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> fieldMapperErrorHandler(FieldMapperErrorHandler<K> fieldMapperErrorHandler) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, fieldMapperErrorHandler, this.rowHandlerErrorHandler, this.maxMethodSize);
    }

    public MapperConfig<K, CD> rowHandlerErrorHandler(RowHandlerErrorHandler rowHandlerErrorHandler) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, rowHandlerErrorHandler, this.maxMethodSize);
    }

    public RowHandlerErrorHandler rowHandlerErrorHandler() {
        return this.rowHandlerErrorHandler;
    }

    public boolean hasFieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler != null && !(this.fieldMapperErrorHandler instanceof RethrowFieldMapperErrorHandler);
    }

    public FieldMapperErrorHandler<K> fieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler;
    }

    public int maxMethodSize() {
        return this.maxMethodSize;
    }

    public MapperConfig<K, CD> maxMethodSize(int maxMethodSize) {
        return new MapperConfig<K, CD>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.rowHandlerErrorHandler, maxMethodSize);
    }
}

