/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.column.joda;

import java.util.ArrayList;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.DefaultDateFormatProperty;
import org.sfm.map.column.TimeZoneProperty;
import org.sfm.map.column.joda.JodaDateTimeFormatterProperty;
import org.sfm.map.column.joda.JodaDateTimeZoneProperty;
import org.sfm.map.mapper.ColumnDefinition;

public class JodaHelper {
    public static DateTimeFormatter[] getDateTimeFormatters(ColumnDefinition<?, ?> columnDefinition) {
        DateTimeZone dateTimeZone = JodaHelper._dateTimeZone(columnDefinition);
        ArrayList<DateTimeFormatter> dtf = new ArrayList<DateTimeFormatter>();
        for (JodaDateTimeFormatterProperty jodaDateTimeFormatterProperty : columnDefinition.lookForAll(JodaDateTimeFormatterProperty.class)) {
            dtf.add(JodaHelper.withZone(jodaDateTimeFormatterProperty.getFormatter(), dateTimeZone));
        }
        for (ColumnProperty columnProperty : columnDefinition.lookForAll(DateFormatProperty.class)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)((DateFormatProperty)columnProperty).getPattern());
            dtf.add(JodaHelper.withZone(dateTimeFormatter, dateTimeZone));
        }
        if (dtf.isEmpty()) {
            DefaultDateFormatProperty defaultDateFormatProperty = columnDefinition.lookFor(DefaultDateFormatProperty.class);
            if (defaultDateFormatProperty == null) {
                throw new IllegalStateException("No date format specified");
            }
            dtf.add(JodaHelper.withZone(DateTimeFormat.forPattern((String)defaultDateFormatProperty.getPattern()), dateTimeZone));
        }
        return dtf.toArray(new DateTimeFormatter[0]);
    }

    private static DateTimeFormatter withZone(DateTimeFormatter dateTimeFormatter, DateTimeZone zoneId) {
        if (zoneId != null) {
            return dateTimeFormatter.withZone(zoneId);
        }
        if (dateTimeFormatter.getZone() == null) {
            return dateTimeFormatter.withZone(DateTimeZone.getDefault());
        }
        return dateTimeFormatter;
    }

    private static DateTimeZone _dateTimeZone(ColumnDefinition<?, ?> columnDefinition) {
        if (columnDefinition.has(JodaDateTimeZoneProperty.class)) {
            return columnDefinition.lookFor(JodaDateTimeZoneProperty.class).getZone();
        }
        if (columnDefinition.has(TimeZoneProperty.class)) {
            return DateTimeZone.forTimeZone((TimeZone)columnDefinition.lookFor(TimeZoneProperty.class).getTimeZone());
        }
        return null;
    }

    public static DateTimeZone getDateTimeZoneOrDefault(ColumnDefinition<?, ?> columnDefinition) {
        DateTimeZone dateTimeZone = JodaHelper._dateTimeZone(columnDefinition);
        return dateTimeZone == null ? DateTimeZone.getDefault() : dateTimeZone;
    }

    public static DateTimeZone getDateTimeZoneOrDefault(Object[] params) {
        if (params != null) {
            for (Object p : params) {
                if (p instanceof ColumnDefinition) {
                    DateTimeZone dateTimeZone = JodaHelper._dateTimeZone((ColumnDefinition)p);
                    if (dateTimeZone == null) continue;
                    return dateTimeZone;
                }
                if (p instanceof DateTimeZone) {
                    return (DateTimeZone)p;
                }
                if (p instanceof TimeZone) {
                    return DateTimeZone.forTimeZone((TimeZone)((TimeZone)p));
                }
                if (p instanceof JodaDateTimeZoneProperty) {
                    return ((JodaDateTimeZoneProperty)p).getZone();
                }
                if (!(p instanceof TimeZoneProperty)) continue;
                return DateTimeZone.forTimeZone((TimeZone)((TimeZoneProperty)p).getTimeZone());
            }
        }
        return DateTimeZone.getDefault();
    }
}

