/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.column.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.TimeZone;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.DefaultDateFormatProperty;
import org.sfm.map.column.TimeZoneProperty;
import org.sfm.map.column.time.JavaDateTimeFormatterProperty;
import org.sfm.map.column.time.JavaZoneIdProperty;
import org.sfm.map.mapper.ColumnDefinition;

public class JavaTimeHelper {
    public static DateTimeFormatter[] getDateTimeFormatters(ColumnDefinition<?, ?> columnDefinition) {
        ArrayList<DateTimeFormatter> dtf = new ArrayList<DateTimeFormatter>();
        ZoneId zoneId = JavaTimeHelper._getZoneId(columnDefinition);
        for (JavaDateTimeFormatterProperty javaDateTimeFormatterProperty : columnDefinition.lookForAll(JavaDateTimeFormatterProperty.class)) {
            dtf.add(JavaTimeHelper.withZone(javaDateTimeFormatterProperty.getFormatter(), zoneId));
        }
        for (ColumnProperty columnProperty : columnDefinition.lookForAll(DateFormatProperty.class)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(((DateFormatProperty)columnProperty).getPattern());
            dtf.add(JavaTimeHelper.withZone(dateTimeFormatter, zoneId));
        }
        if (dtf.isEmpty()) {
            DefaultDateFormatProperty defaultDateFormatProperty = columnDefinition.lookFor(DefaultDateFormatProperty.class);
            if (defaultDateFormatProperty == null) {
                throw new IllegalStateException("No date format specified");
            }
            dtf.add(JavaTimeHelper.withZone(DateTimeFormatter.ofPattern(defaultDateFormatProperty.getPattern()), zoneId));
        }
        return dtf.toArray(new DateTimeFormatter[0]);
    }

    private static DateTimeFormatter withZone(DateTimeFormatter dateTimeFormatter, ZoneId zoneId) {
        if (zoneId != null) {
            return dateTimeFormatter.withZone(zoneId);
        }
        if (dateTimeFormatter.getZone() == null) {
            return dateTimeFormatter.withZone(ZoneId.systemDefault());
        }
        return dateTimeFormatter;
    }

    public static ZoneId getZoneIdOrDefault(ColumnDefinition<?, ?> columnDefinition) {
        ZoneId zoneId = JavaTimeHelper._getZoneId(columnDefinition);
        if (zoneId != null) {
            return zoneId;
        }
        return ZoneId.systemDefault();
    }

    private static ZoneId _getZoneId(ColumnDefinition<?, ?> columnDefinition) {
        if (columnDefinition.has(JavaZoneIdProperty.class)) {
            return columnDefinition.lookFor(JavaZoneIdProperty.class).getZoneId();
        }
        if (columnDefinition.has(TimeZoneProperty.class)) {
            return columnDefinition.lookFor(TimeZoneProperty.class).getTimeZone().toZoneId();
        }
        return null;
    }

    public static ZoneId getZoneIdOrDefault(Object[] params) {
        if (params != null) {
            for (Object p : params) {
                if (p instanceof ColumnDefinition) {
                    ZoneId dateTimeZone = JavaTimeHelper._getZoneId((ColumnDefinition)p);
                    if (dateTimeZone == null) continue;
                    return dateTimeZone;
                }
                if (p instanceof ZoneId) {
                    return (ZoneId)p;
                }
                if (p instanceof TimeZone) {
                    return ((TimeZone)p).toZoneId();
                }
                if (p instanceof JavaZoneIdProperty) {
                    return ((JavaZoneIdProperty)p).getZoneId();
                }
                if (!(p instanceof TimeZoneProperty)) continue;
                return ((TimeZoneProperty)p).getTimeZone().toZoneId();
            }
        }
        return ZoneId.systemDefault();
    }
}

