/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.context.impl;

import org.sfm.jdbc.impl.BreakDetector;
import org.sfm.map.MappingContext;

public class BreakDetectorMappingContext<S>
extends MappingContext<S> {
    private final BreakDetector<S>[] breakDetectors;
    private final BreakDetector<S> rootDetector;

    public BreakDetectorMappingContext(BreakDetector<S>[] breakDetectors, int rootDetector) {
        this.breakDetectors = breakDetectors;
        this.rootDetector = rootDetector == -1 ? null : breakDetectors[rootDetector];
    }

    private BreakDetector<S> getBreakDetector(int i) {
        return this.breakDetectors != null ? this.breakDetectors[i] : null;
    }

    @Override
    public boolean broke(int i) {
        BreakDetector<S> breakDetector = this.getBreakDetector(i);
        return breakDetector == null || breakDetector.isBroken();
    }

    @Override
    public boolean rootBroke() {
        return this.rootDetector == null || this.rootDetector.isBroken();
    }

    @Override
    public void handle(S source) {
        if (this.breakDetectors == null) {
            return;
        }
        for (BreakDetector<S> bs : this.breakDetectors) {
            if (bs == null) continue;
            bs.handle(source);
        }
    }

    @Override
    public void markAsBroken() {
        if (this.breakDetectors == null) {
            return;
        }
        for (BreakDetector<S> bs : this.breakDetectors) {
            if (bs == null) continue;
            bs.markAsBroken();
        }
    }

    @Override
    public <T> T context(int i) {
        return null;
    }
}

