/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.getter;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.sfm.reflect.Getter;
import org.sfm.utils.UUIDHelper;

public final class UUIDUnspecifiedTypeGetter<R>
implements Getter<R, UUID> {
    private final Getter<R, ?> getter;

    public UUIDUnspecifiedTypeGetter(Getter<R, ?> getter) {
        this.getter = getter;
    }

    @Override
    public UUID get(R target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return UUID.fromString((String)o);
        }
        if (o instanceof byte[]) {
            return UUIDHelper.fromBytes((byte[])o);
        }
        if (o instanceof InputStream) {
            return UUIDHelper.fromBytes(this.toBytes((InputStream)o));
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to UUID");
    }

    private byte[] toBytes(InputStream o) throws IOException {
        try {
            int currentIndex = 0;
            byte[] bytes = new byte[16];
            while (true) {
                int nbRead;
                if ((nbRead = o.read(bytes, currentIndex, bytes.length - currentIndex)) == -1) {
                    byte[] byArray = bytes;
                    return byArray;
                }
                if ((currentIndex += nbRead) < bytes.length) continue;
                byte[] byArray = bytes;
                return byArray;
            }
        }
        finally {
            o.close();
        }
    }

    public String toString() {
        return "UUIDUnspecifiedTypeGetter{getter=" + this.getter + '}';
    }
}

