/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.getter.impl.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaOffsetDateTimeFromObjectGetter<S>
implements Getter<S, OffsetDateTime> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaOffsetDateTimeFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public OffsetDateTime get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)o).getTime());
            return instant.atOffset(this.zone.getRules().getOffset(instant));
        }
        if (o instanceof OffsetDateTime) {
            return (OffsetDateTime)o;
        }
        if (o instanceof ZonedDateTime) {
            return ((ZonedDateTime)o).toOffsetDateTime();
        }
        if (o instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)o;
            return localDateTime.atOffset(this.zone.getRules().getOffset(localDateTime));
        }
        if (o instanceof LocalDate) {
            LocalDateTime localDateTime = ((LocalDate)o).atTime(0, 0);
            return localDateTime.atOffset(this.zone.getRules().getOffset(localDateTime));
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to OffsetDateTime");
    }

    public String toString() {
        return "JavaOffsetDateTimeFromObjectGetter{getter=" + this.getter + '}';
    }
}

