/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.getter.impl.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaOffsetTimeFromObjectGetter<S>
implements Getter<S, OffsetTime> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaOffsetTimeFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public OffsetTime get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)o).getTime());
            return instant.atOffset(this.zone.getRules().getOffset(instant)).toOffsetTime();
        }
        if (o instanceof OffsetTime) {
            return (OffsetTime)o;
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).atZone(this.zone).toOffsetDateTime().toOffsetTime();
        }
        if (o instanceof LocalTime) {
            return ((LocalTime)o).atOffset(this.zone.getRules().getStandardOffset(Instant.now()));
        }
        if (o instanceof TemporalAccessor) {
            return OffsetTime.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to OffsetTime");
    }

    public String toString() {
        return "JavaOffsetTimeFromObjectGetter{getter=" + this.getter + '}';
    }
}

