/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.getter.impl.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaZonedDateTimeFromObjectGetter<S>
implements Getter<S, ZonedDateTime> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaZonedDateTimeFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public ZonedDateTime get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone);
        }
        if (o instanceof ZonedDateTime) {
            return (ZonedDateTime)o;
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).atZone(this.zone);
        }
        if (o instanceof TemporalAccessor) {
            return ZonedDateTime.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to ZonedDateTime");
    }

    public String toString() {
        return "JavaZonedDateTimeFromObjectGetter{getter=" + this.getter + '}';
    }
}

