/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.getter.joda;

import java.lang.reflect.Type;
import java.util.Date;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.getter.impl.joda.JodaDateTimeFromDateGetter;
import org.sfm.map.getter.impl.joda.JodaLocalDateFromDateGetter;
import org.sfm.map.getter.impl.joda.JodaLocalDateTimeFromDateGetter;
import org.sfm.map.getter.impl.joda.JodaLocalTimeFromObjectGetter;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.Asserts;

public class JodaTimeGetterFactory<T, K extends FieldKey<K>>
implements GetterFactory<T, K> {
    private final GetterFactory<T, K> dateGetterFactory;

    public JodaTimeGetterFactory(GetterFactory<T, K> dateGetterFactory) {
        Asserts.requireNonNull("dateGetterFactory", dateGetterFactory);
        this.dateGetterFactory = dateGetterFactory;
    }

    @Override
    public <P> Getter<T, P> newGetter(Type target, K key, ColumnDefinition<?, ?> columnDefinition) {
        Class clazz = TypeHelper.toClass(target);
        Getter getter = this.dateGetterFactory.newGetter((Type)((Object)Date.class), key, columnDefinition);
        if (JodaTimeClasses.isJodaDateTime(clazz)) {
            return new JodaDateTimeFromDateGetter<T>(getter);
        }
        if (JodaTimeClasses.isJodaLocalDate(clazz)) {
            return new JodaLocalDateFromDateGetter<T>(getter);
        }
        if (JodaTimeClasses.isJodaLocalDateTime(clazz)) {
            return new JodaLocalDateTimeFromDateGetter<T>(getter);
        }
        if (JodaTimeClasses.isJodaLocalTime(clazz)) {
            return new JodaLocalTimeFromObjectGetter<T>(getter);
        }
        return null;
    }
}

