/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl;

import java.sql.SQLException;
import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.tuples.Tuple3;
import org.sfm.utils.Enumarable;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.Predicate;
import org.sfm.utils.conv.Converter;

public class DiscriminatorEnumerable<S, T>
implements Enumarable<T> {
    private final Tuple3<Predicate<S>, Mapper<S, T>, MappingContext<? super S>>[] discriminatorMappers;
    private final Enumarable<S> sourceEnumarable;
    private final Converter<S, String> errorMessageGenerator;
    private T currentValue;
    private T nextValue;
    private Mapper<S, T> currentMapper;
    private MappingContext<? super S> currentMappingContext;

    public DiscriminatorEnumerable(Tuple3<Predicate<S>, Mapper<S, T>, MappingContext<? super S>>[] discriminatorMappers, Enumarable<S> sourceEnumarable, Converter<S, String> errorMessageGenerator) {
        this.discriminatorMappers = discriminatorMappers;
        this.sourceEnumarable = sourceEnumarable;
        this.errorMessageGenerator = errorMessageGenerator;
    }

    @Override
    public boolean next() {
        try {
            this.currentValue = this.nextValue;
            this.nextValue = null;
            while (this.sourceEnumarable.next()) {
                this.checkMapper();
                S source = this.sourceEnumarable.currentValue();
                this.currentMappingContext.handle(source);
                if (this.currentMappingContext.rootBroke()) {
                    if (this.currentValue == null) {
                        this.currentValue = this.currentMapper.map((S)source, this.currentMappingContext);
                        continue;
                    }
                    this.nextValue = this.currentMapper.map((S)source, this.currentMappingContext);
                    return true;
                }
                this.currentMapper.mapTo((S)source, this.currentValue, this.currentMappingContext);
            }
            return this.currentValue != null;
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            return false;
        }
    }

    @Override
    public T currentValue() {
        return this.currentValue;
    }

    private void checkMapper() throws SQLException {
        for (Tuple3<Predicate<S>, Mapper<S, T>, MappingContext<S>> tuple3 : this.discriminatorMappers) {
            if (!((Predicate)tuple3.first()).test(this.sourceEnumarable.currentValue())) continue;
            if (tuple3.second() != this.currentMapper) {
                this.markAsBroken();
                this.currentMapper = (Mapper)tuple3.second();
                this.currentMappingContext = tuple3.third();
            }
            return;
        }
        this.mapperNotFound();
    }

    private void mapperNotFound() {
        String errorMessage;
        try {
            errorMessage = this.errorMessageGenerator.convert(this.sourceEnumarable.currentValue());
        }
        catch (Exception e) {
            errorMessage = "NA";
        }
        throw new MappingException("No mapper found for " + errorMessage);
    }

    private void markAsBroken() {
        for (Tuple3<Predicate<S>, Mapper<S, T>, MappingContext<S>> tuple3 : this.discriminatorMappers) {
            tuple3.third().markAsBroken();
        }
    }
}

