/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.fieldmapper;

import java.lang.reflect.Type;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.GetterFactory;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.impl.fieldmapper.BooleanFieldMapper;
import org.sfm.map.impl.fieldmapper.ByteFieldMapper;
import org.sfm.map.impl.fieldmapper.CharacterFieldMapper;
import org.sfm.map.impl.fieldmapper.ConstantSourceFieldMapperFactory;
import org.sfm.map.impl.fieldmapper.DoubleFieldMapper;
import org.sfm.map.impl.fieldmapper.FieldMapperImpl;
import org.sfm.map.impl.fieldmapper.FloatFieldMapper;
import org.sfm.map.impl.fieldmapper.IntFieldMapper;
import org.sfm.map.impl.fieldmapper.LongFieldMapper;
import org.sfm.map.impl.fieldmapper.ShortFieldMapper;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorDefinitions;
import org.sfm.reflect.InstantiatorOnGetter;
import org.sfm.reflect.ObjectGetterFactory;
import org.sfm.reflect.ObjectSetterFactory;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.ErrorDoc;

public final class ConstantSourceFieldMapperFactoryImpl<S, K extends FieldKey<K>>
implements ConstantSourceFieldMapperFactory<S, K> {
    private final GetterFactory<? super S, K> getterFactory;

    public ConstantSourceFieldMapperFactoryImpl(GetterFactory<? super S, K> getterFactory) {
        this.getterFactory = getterFactory;
    }

    private <T, P> FieldMapper<S, T> primitiveIndexedFieldMapper(Class<P> type, Setter<T, ? super P> setter, Getter<? super S, ? extends P> getter) {
        if (type.equals(Boolean.TYPE)) {
            return new BooleanFieldMapper<S, T>(ObjectGetterFactory.toBooleanGetter(getter), ObjectSetterFactory.toBooleanSetter(setter));
        }
        if (type.equals(Integer.TYPE)) {
            return new IntFieldMapper<S, T>(ObjectGetterFactory.toIntGetter(getter), ObjectSetterFactory.toIntSetter(setter));
        }
        if (type.equals(Long.TYPE)) {
            return new LongFieldMapper<S, T>(ObjectGetterFactory.toLongGetter(getter), ObjectSetterFactory.toLongSetter(setter));
        }
        if (type.equals(Float.TYPE)) {
            return new FloatFieldMapper<S, T>(ObjectGetterFactory.toFloatGetter(getter), ObjectSetterFactory.toFloatSetter(setter));
        }
        if (type.equals(Double.TYPE)) {
            return new DoubleFieldMapper<S, T>(ObjectGetterFactory.toDoubleGetter(getter), ObjectSetterFactory.toDoubleSetter(setter));
        }
        if (type.equals(Byte.TYPE)) {
            return new ByteFieldMapper<S, T>(ObjectGetterFactory.toByteGetter(getter), ObjectSetterFactory.toByteSetter(setter));
        }
        if (type.equals(Character.TYPE)) {
            return new CharacterFieldMapper<S, T>(ObjectGetterFactory.toCharGetter(getter), ObjectSetterFactory.toCharacterSetter(setter));
        }
        if (type.equals(Short.TYPE)) {
            return new ShortFieldMapper<S, T>(ObjectGetterFactory.toShortGetter(getter), ObjectSetterFactory.toShortSetter(setter));
        }
        throw new UnsupportedOperationException("Type " + type + " is not primitive");
    }

    @Override
    public <T, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> propertyMapping, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        PropertyMeta<T, P> propertyMeta = propertyMapping.getPropertyMeta();
        Type propertyType = propertyMeta.getPropertyType();
        Setter<T, P> setter = propertyMeta.getSetter();
        K key = propertyMapping.getColumnKey();
        Class type = TypeHelper.toClass(propertyType);
        Getter<Object, Object> getter = propertyMapping.getColumnDefinition().getCustomGetter();
        if (getter == null) {
            getter = this.getterFromFactory(propertyMapping, propertyType);
        }
        if (getter == null) {
            mappingErrorHandler.accessorNotFound("Could not find getter for " + key + " type " + propertyType + " See " + ErrorDoc.toUrl("CSFM_GETTER_NOT_FOUND"));
            return null;
        }
        if (type.isPrimitive()) {
            return this.primitiveIndexedFieldMapper(type, setter, getter);
        }
        return new FieldMapperImpl(getter, setter);
    }

    private <T, P> Getter<? super S, ? extends P> getterFromFactory(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> propertyMapping, Type propertyType) {
        Getter getter = null;
        if (propertyMapping.getColumnDefinition().hasCustomFactory()) {
            GetterFactory<?, K> cGetterFactory = propertyMapping.getColumnDefinition().getCustomGetterFactory();
            getter = cGetterFactory.newGetter(propertyType, propertyMapping.getColumnKey(), propertyMapping.getColumnDefinition());
        }
        if (getter == null) {
            getter = this.getterFactory.newGetter(propertyType, propertyMapping.getColumnKey(), propertyMapping.getColumnDefinition());
        }
        if (getter == null) {
            Type sourceType;
            ClassMeta<P> classMeta = propertyMapping.getPropertyMeta().getPropertyClassMeta();
            InstantiatorDefinitions.CompatibilityScorer scorer = InstantiatorDefinitions.getCompatibilityScorer(propertyMapping.getColumnKey());
            InstantiatorDefinition id = InstantiatorDefinitions.lookForCompatibleOneArgument(classMeta.getInstantiatorDefinitions(), scorer);
            if (id != null && (getter = this.getterFactory.newGetter(sourceType = id.getParameters()[0].getGenericType(), propertyMapping.getColumnKey(), propertyMapping.getColumnDefinition())) != null) {
                Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id);
                getter = new InstantiatorOnGetter(instantiator, getter);
            }
        }
        return getter;
    }
}

