/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.util.ArrayList;
import java.util.List;
import org.sfm.map.FieldKey;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.ColumnDefinitionProvider;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.BiConsumer;
import org.sfm.utils.ConstantUnaryFactory;
import org.sfm.utils.Predicate;
import org.sfm.utils.UnaryFactory;

public abstract class AbstractColumnDefinitionProvider<C extends ColumnDefinition<K, C>, K extends FieldKey<K>>
implements ColumnDefinitionProvider<C, K> {
    protected final List<Tuple2<Predicate<? super K>, C>> definitions;
    protected final List<Tuple2<Predicate<? super K>, UnaryFactory<? super K, ColumnProperty>>> properties;

    public AbstractColumnDefinitionProvider() {
        this.definitions = new ArrayList<Tuple2<Predicate<? super K>, C>>();
        this.properties = new ArrayList<Tuple2<Predicate<? super K>, UnaryFactory<? super K, ColumnProperty>>>();
    }

    public AbstractColumnDefinitionProvider(List<Tuple2<Predicate<? super K>, C>> definitions, List<Tuple2<Predicate<? super K>, UnaryFactory<? super K, ColumnProperty>>> properties) {
        this.definitions = definitions;
        this.properties = properties;
    }

    public void addColumnDefinition(Predicate<? super K> predicate, C definition) {
        this.definitions.add(new Tuple2<Predicate<? super K>, C>(predicate, definition));
    }

    public void addColumnProperty(Predicate<? super K> predicate, UnaryFactory<? super K, ColumnProperty> propertyFactory) {
        this.properties.add(new Tuple2<Predicate<? super K>, UnaryFactory<? super K, ColumnProperty>>(predicate, propertyFactory));
    }

    @Override
    public C getColumnDefinition(K key) {
        Object definition = this.identity();
        for (Tuple2<Predicate<K>, C> tuple2 : this.definitions) {
            if (!tuple2.first().test(key)) continue;
            definition = this.compose(definition, (ColumnDefinition)tuple2.second());
        }
        for (Tuple2<Predicate<K>, Object> tuple2 : this.properties) {
            ColumnProperty columnProperty;
            if (!tuple2.first().test(key) || (columnProperty = (ColumnProperty)((UnaryFactory)tuple2.second()).newInstance(key)) == null) continue;
            definition = ((ColumnDefinition)definition).add(columnProperty);
        }
        return definition;
    }

    protected abstract C compose(C var1, C var2);

    protected abstract C identity();

    public List<Tuple2<Predicate<? super K>, C>> getDefinitions() {
        return this.definitions;
    }

    public List<Tuple2<Predicate<? super K>, UnaryFactory<? super K, ColumnProperty>>> getProperties() {
        return this.properties;
    }

    @Override
    public <CP extends ColumnProperty, BC extends BiConsumer<Predicate<? super K>, CP>> BC forEach(Class<CP> propertyType, BC consumer) {
        for (Tuple2<Predicate<K>, C> tuple2 : this.definitions) {
            ColumnProperty cp = (ColumnProperty)((ColumnDefinition)tuple2.getElement1()).lookFor(propertyType);
            if (cp == null) continue;
            consumer.accept(tuple2.getElement0(), (ColumnProperty)cp);
        }
        for (Tuple2<Predicate<K>, Object> tuple2 : this.properties) {
            ColumnProperty columnProperty;
            UnaryFactory unaryFactory = (UnaryFactory)tuple2.getElement1();
            if (!(unaryFactory instanceof ConstantUnaryFactory) || !propertyType.isInstance(columnProperty = (ColumnProperty)unaryFactory.newInstance(null))) continue;
            consumer.accept(tuple2.getElement0(), propertyType.cast(columnProperty));
        }
        return consumer;
    }
}

