/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sfm.map.EnumarableMapper;
import org.sfm.map.MappingException;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.utils.Enumarable;
import org.sfm.utils.EnumarableIterator;
import org.sfm.utils.EnumarableSpliterator;
import org.sfm.utils.RowHandler;

public abstract class AbstractEnumarableMapper<S, T, E extends Exception>
implements EnumarableMapper<S, T, E> {
    protected final RowHandlerErrorHandler errorHandler;

    public AbstractEnumarableMapper(RowHandlerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final <H extends RowHandler<? super T>> H forEach(S source, H handler) throws E, MappingException {
        Enumarable<T> enumarable = this.newEnumarableOfT(source);
        while (enumarable.next()) {
            T t = enumarable.currentValue();
            this.handleT(handler, t);
        }
        return handler;
    }

    public <H extends RowHandler<? super T>> void handleT(H handler, T t) {
        try {
            handler.handle(t);
        }
        catch (Throwable e) {
            this.errorHandler.handlerError(e, t);
        }
    }

    @Override
    public final Iterator<T> iterator(S source) throws MappingException, E {
        return new EnumarableIterator<T>(this.newEnumarableOfT(source));
    }

    @Override
    public final Stream<T> stream(S source) throws MappingException, E {
        return StreamSupport.stream(new EnumarableSpliterator<T>(this.newEnumarableOfT(source)), false);
    }

    protected abstract Enumarable<T> newEnumarableOfT(S var1) throws E;
}

