/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.reflect.Instantiator;
import org.sfm.utils.ErrorHelper;

public abstract class AbstractMapper<S, T>
implements Mapper<S, T> {
    private final Instantiator<? super S, T> instantiator;

    public AbstractMapper(Instantiator<? super S, T> instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    public final T map(S source) throws MappingException {
        return this.map(source, null);
    }

    @Override
    public final T map(S source, MappingContext<? super S> mappingContext) throws MappingException {
        try {
            T target = this.instantiator.newInstance(source);
            this.mapFields(source, target, mappingContext);
            return target;
        }
        catch (Exception e) {
            return ErrorHelper.rethrow(e);
        }
    }

    @Override
    public final void mapTo(S source, T target, MappingContext<? super S> mappingContext) throws MappingException {
        try {
            this.mapToFields(source, target, mappingContext);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
    }

    protected abstract void mapFields(S var1, T var2, MappingContext<? super S> var3) throws Exception;

    protected abstract void mapToFields(S var1, T var2, MappingContext<? super S> var3) throws Exception;

    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append("instantiator=").append(String.valueOf(this.instantiator));
    }
}

