/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.mapper.FieldMapperMapperBuilder;
import org.sfm.map.mapper.KeyFactory;
import org.sfm.map.mapper.MapperSource;
import org.sfm.reflect.meta.ClassMeta;

public abstract class AbstractMapperBuilder<S, T, K extends FieldKey<K>, M, B extends AbstractMapperBuilder<S, T, K, M, B>> {
    private final FieldMapperMapperBuilder<S, T, K> fieldMapperMapperBuilder;
    protected final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder;
    private int calculatedIndex;

    public AbstractMapperBuilder(ClassMeta<T> classMeta, MappingContextFactoryBuilder<? super S, K> parentBuilder, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, MapperSource<? super S, K> mapperSource, KeyFactory<K> keyFactory, int startIndex) {
        this.fieldMapperMapperBuilder = new FieldMapperMapperBuilder<S, T, K>(mapperSource, classMeta, mapperConfig, parentBuilder, keyFactory);
        this.mapperConfig = mapperConfig;
        this.mappingContextFactoryBuilder = parentBuilder;
        this.calculatedIndex = startIndex;
    }

    public final M mapper() {
        Mapper<S, T> mapper = this.fieldMapperMapperBuilder.mapper();
        if (this.fieldMapperMapperBuilder.hasJoin()) {
            return this.newJoinJdbcMapper(mapper);
        }
        return this.newStaticJdbcMapper(mapper);
    }

    public final B addKey(String column) {
        return this.addMapping(column, this.calculatedIndex++, FieldMapperColumnDefinition.key());
    }

    public final B addMapping(String column) {
        return this.addMapping(column, this.calculatedIndex++);
    }

    public final B addMapping(String column, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addMapping(column, this.calculatedIndex++, columnDefinition);
    }

    public final B addMapping(String column, ColumnProperty ... properties) {
        return this.addMapping(column, this.calculatedIndex++, properties);
    }

    public final B addMapping(String column, int index) {
        return this.addMapping(this.key(column, index), new ColumnProperty[0]);
    }

    public final B addMapping(String column, int index, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addMapping(this.key(column, index), columnDefinition);
    }

    public final B addMapping(String column, int index, ColumnProperty ... properties) {
        return this.addMapping(this.key(column, index), properties);
    }

    public final B addMapper(FieldMapper<S, T> mapper) {
        this.fieldMapperMapperBuilder.addMapper(mapper);
        return (B)this;
    }

    public final B addMapping(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        this.fieldMapperMapperBuilder.addMapping(key, columnDefinition);
        return (B)this;
    }

    public final B addMapping(K key, ColumnProperty ... properties) {
        this.fieldMapperMapperBuilder.addMapping(key, FieldMapperColumnDefinition.of(properties));
        return (B)this;
    }

    protected abstract K key(String var1, int var2);

    protected abstract M newJoinJdbcMapper(Mapper<S, T> var1);

    protected abstract M newStaticJdbcMapper(Mapper<S, T> var1);
}

