/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Map;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapperErrorHandler;
import org.sfm.map.IgnoreMapperBuilderErrorHandler;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.MapperConfig;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.error.RethrowMapperBuilderErrorHandler;
import org.sfm.map.error.RethrowRowHandlerErrorHandler;
import org.sfm.map.impl.CaseInsensitiveFieldKeyNamePredicate;
import org.sfm.map.mapper.AbstractColumnDefinitionProvider;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.ColumnDefinitionProvider;
import org.sfm.map.mapper.DefaultPropertyNameMatcherFactory;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyNameMatcherFactory;
import org.sfm.utils.ConstantUnaryFactory;
import org.sfm.utils.Predicate;
import org.sfm.utils.UnaryFactory;

public abstract class AbstractMapperFactory<K extends FieldKey<K>, CD extends ColumnDefinition<K, CD>, MF extends AbstractMapperFactory<K, CD, MF>> {
    private FieldMapperErrorHandler<K> fieldMapperErrorHandler = null;
    private MapperBuilderErrorHandler mapperBuilderErrorHandler = new RethrowMapperBuilderErrorHandler();
    private RowHandlerErrorHandler rowHandlerErrorHandler = new RethrowRowHandlerErrorHandler();
    private final AbstractColumnDefinitionProvider<CD, K> columnDefinitions;
    private final CD identity;
    private boolean useAsm = true;
    private boolean disableAsm = false;
    private boolean failOnAsm = false;
    private int asmMapperNbFieldsLimit = 792;
    private PropertyNameMatcherFactory propertyNameMatcherFactory = DefaultPropertyNameMatcherFactory.DEFAULT;
    private ReflectionService reflectionService = null;
    private int maxMethodSize = 128;

    public AbstractMapperFactory(AbstractMapperFactory<K, CD, ?> config) {
        this.columnDefinitions = config.columnDefinitions;
        this.identity = config.identity;
        this.useAsm = config.useAsm;
        this.failOnAsm = config.failOnAsm;
        this.asmMapperNbFieldsLimit = config.asmMapperNbFieldsLimit;
        this.propertyNameMatcherFactory = config.propertyNameMatcherFactory;
        this.reflectionService = config.reflectionService;
        this.maxMethodSize = config.maxMethodSize;
    }

    public AbstractMapperFactory(AbstractColumnDefinitionProvider<CD, K> columnDefinitions, CD identity) {
        this.columnDefinitions = columnDefinitions;
        this.identity = identity;
    }

    public final MF fieldMapperErrorHandler(FieldMapperErrorHandler<K> fieldMapperErrorHandler) {
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        return (MF)this;
    }

    public final MF ignorePropertyNotFound() {
        this.mapperBuilderErrorHandler = new IgnoreMapperBuilderErrorHandler();
        return (MF)this;
    }

    public final MF mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        return (MF)this;
    }

    public final MF rowHandlerErrorHandler(RowHandlerErrorHandler rowHandlerErrorHandler) {
        this.rowHandlerErrorHandler = rowHandlerErrorHandler;
        return (MF)this;
    }

    public final MF useAsm(boolean useAsm) {
        this.useAsm = useAsm;
        return (MF)this;
    }

    public final MF disableAsm(boolean disableAsm) {
        this.disableAsm = disableAsm;
        return (MF)this;
    }

    public final MF reflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
        return (MF)this;
    }

    public final MapperConfig<K, CD> mapperConfig() {
        return MapperConfig.config(this.columnDefinitions).mapperBuilderErrorHandler(this.mapperBuilderErrorHandler).propertyNameMatcherFactory(this.propertyNameMatcherFactory).failOnAsm(this.failOnAsm).asmMapperNbFieldsLimit(this.asmMapperNbFieldsLimit).fieldMapperErrorHandler(this.fieldMapperErrorHandler).rowHandlerErrorHandler(this.rowHandlerErrorHandler).maxMethodSize(this.maxMethodSize);
    }

    public final MF addAlias(String key, String value) {
        return this.addColumnDefinition(key, ((ColumnDefinition)this.identity).addRename(value));
    }

    public final MF addColumnDefinition(String key, CD columnDefinition) {
        return this.addColumnDefinition(new CaseInsensitiveFieldKeyNamePredicate(key), columnDefinition);
    }

    public final MF addColumnDefinition(Predicate<? super K> predicate, CD columnDefinition) {
        this.columnDefinitions.addColumnDefinition(predicate, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnProperty(String name, ColumnProperty ... properties) {
        for (ColumnProperty property : properties) {
            this.columnDefinitions.addColumnProperty(new CaseInsensitiveFieldKeyNamePredicate(name), new ConstantUnaryFactory(property));
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, ColumnProperty ... properties) {
        for (ColumnProperty property : properties) {
            this.columnDefinitions.addColumnProperty(predicate, new ConstantUnaryFactory(property));
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, UnaryFactory<K, ColumnProperty> propertyFactory) {
        this.columnDefinitions.addColumnProperty(predicate, propertyFactory);
        return (MF)this;
    }

    public final MF propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        return (MF)this;
    }

    public final MF addAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
        return (MF)this;
    }

    public final MF failOnAsm(boolean b) {
        this.failOnAsm = b;
        return (MF)this;
    }

    public final MF asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        return (MF)this;
    }

    public final MF maxMethodSize(int maxMethodSize) {
        this.maxMethodSize = maxMethodSize;
        return (MF)this;
    }

    public final MF addKeys(String ... columns) {
        for (String col : columns) {
            this.addColumnDefinition(col, ((ColumnDefinition)this.identity).addKey());
        }
        return (MF)this;
    }

    public final RowHandlerErrorHandler rowHandlerErrorHandler() {
        return this.rowHandlerErrorHandler;
    }

    public final <T> ClassMeta<T> getClassMeta(TypeReference<T> target) {
        return this.getClassMeta(target.getType());
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public final <T> ClassMeta<T> getClassMeta(Type target) {
        return this.getReflectionService().getClassMeta(target);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(TypeReference<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator(target.getType(), instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Class<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator((Type)target, instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Type target, Member instantiator) {
        return this.getReflectionService().getClassMetaExtraInstantiator(target, instantiator);
    }

    protected ReflectionService getReflectionService() {
        if (this.reflectionService != null) {
            return this.reflectionService;
        }
        return ReflectionService.newInstance(this.disableAsm, this.useAsm);
    }

    public ColumnDefinitionProvider<CD, K> columnDefinitions() {
        return this.columnDefinitions;
    }
}

