/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.SetterFactoryProperty;
import org.sfm.map.column.SetterProperty;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.impl.fieldmapper.BooleanFieldMapper;
import org.sfm.map.impl.fieldmapper.ByteFieldMapper;
import org.sfm.map.impl.fieldmapper.CharacterFieldMapper;
import org.sfm.map.impl.fieldmapper.DoubleFieldMapper;
import org.sfm.map.impl.fieldmapper.FieldMapperImpl;
import org.sfm.map.impl.fieldmapper.FloatFieldMapper;
import org.sfm.map.impl.fieldmapper.IntFieldMapper;
import org.sfm.map.impl.fieldmapper.LongFieldMapper;
import org.sfm.map.impl.fieldmapper.ShortFieldMapper;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.SetterOnGetter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.primitive.BooleanGetter;
import org.sfm.reflect.primitive.BooleanSetter;
import org.sfm.reflect.primitive.ByteGetter;
import org.sfm.reflect.primitive.ByteSetter;
import org.sfm.reflect.primitive.CharacterGetter;
import org.sfm.reflect.primitive.CharacterSetter;
import org.sfm.reflect.primitive.DoubleGetter;
import org.sfm.reflect.primitive.DoubleSetter;
import org.sfm.reflect.primitive.FloatGetter;
import org.sfm.reflect.primitive.FloatSetter;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.reflect.primitive.IntSetter;
import org.sfm.reflect.primitive.LongGetter;
import org.sfm.reflect.primitive.LongSetter;
import org.sfm.reflect.primitive.ShortGetter;
import org.sfm.reflect.primitive.ShortSetter;
import org.sfm.utils.ErrorDoc;

public class ConstantTargetFieldMapperFactorImpl<T, K extends FieldKey<K>>
implements ConstantTargetFieldMapperFactory<T, K> {
    private final SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory;

    public ConstantTargetFieldMapperFactorImpl(SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory) {
        this.setterFactory = setterFactory;
    }

    @Override
    public <S, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<S, P, K, FieldMapperColumnDefinition<K>> pm, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        Getter<?, ?> customGetter = pm.getColumnDefinition().getCustomGetter();
        Getter<Object, Object> getter = customGetter != null ? customGetter : pm.getPropertyMeta().getGetter();
        Setter<Object, Object> setter = null;
        SetterProperty setterProperty = pm.getColumnDefinition().lookFor(SetterProperty.class);
        if (setterProperty != null) {
            setter = setterProperty.getSetter();
        }
        if (setter == null) {
            setter = this.setterFromFactory(pm);
        }
        if (TypeHelper.isPrimitive(pm.getPropertyMeta().getPropertyType())) {
            if (getter instanceof BooleanGetter && setter instanceof BooleanSetter) {
                return new BooleanFieldMapper((BooleanGetter)((Object)getter), (BooleanSetter)((Object)setter));
            }
            if (getter instanceof ByteGetter && setter instanceof ByteSetter) {
                return new ByteFieldMapper((ByteGetter)((Object)getter), (ByteSetter)((Object)setter));
            }
            if (getter instanceof CharacterGetter && setter instanceof CharacterSetter) {
                return new CharacterFieldMapper((CharacterGetter)((Object)getter), (CharacterSetter)((Object)setter));
            }
            if (getter instanceof ShortGetter && setter instanceof ShortSetter) {
                return new ShortFieldMapper((ShortGetter)((Object)getter), (ShortSetter)((Object)setter));
            }
            if (getter instanceof IntGetter && setter instanceof IntSetter) {
                return new IntFieldMapper((IntGetter)((Object)getter), (IntSetter)((Object)setter));
            }
            if (getter instanceof LongGetter && setter instanceof LongSetter) {
                return new LongFieldMapper((LongGetter)((Object)getter), (LongSetter)((Object)setter));
            }
            if (getter instanceof FloatGetter && setter instanceof FloatSetter) {
                return new FloatFieldMapper((FloatGetter)((Object)getter), (FloatSetter)((Object)setter));
            }
            if (getter instanceof DoubleGetter && setter instanceof DoubleSetter) {
                return new DoubleFieldMapper((DoubleGetter)((Object)getter), (DoubleSetter)((Object)setter));
            }
        }
        if (getter == null) {
            mappingErrorHandler.accessorNotFound("Could not find getter for " + pm + " See " + ErrorDoc.toUrl("CTFM_GETTER_NOT_FOUND"));
            return null;
        }
        if (setter == null) {
            mappingErrorHandler.accessorNotFound("Could not find setter for " + pm + " See " + ErrorDoc.toUrl("CTFM_SETTER_NOT_FOUND"));
            return null;
        }
        return new FieldMapperImpl(getter, setter);
    }

    private <S, P> Setter<T, P> setterFromFactory(PropertyMapping<S, ?, K, FieldMapperColumnDefinition<K>> pm) {
        PropertyMeta subProp;
        Setter<T, P> subSetter;
        ObjectClassMeta ocm;
        ClassMeta<?> propertyClassMeta;
        Setter setter = null;
        SetterFactoryProperty setterFactoryProperty = pm.getColumnDefinition().lookFor(SetterFactoryProperty.class);
        if (setterFactoryProperty != null) {
            SetterFactory<?, ?> setterFactory = setterFactoryProperty.getSetterFactory();
            setter = setterFactory.getSetter(pm);
        }
        if (setter == null) {
            setter = this.setterFactory.getSetter(pm);
        }
        if (setter == null && (propertyClassMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)propertyClassMeta).getNumberOfProperties() == 1 && (subSetter = this.setterFromFactory(pm.propertyMeta(subProp = ocm.getFirstProperty()))) != null) {
            return new SetterOnGetter(subSetter, subProp.getGetter());
        }
        return setter;
    }

    public static <T, K extends FieldKey<K>> ConstantTargetFieldMapperFactory<T, K> instance(SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory) {
        return new ConstantTargetFieldMapperFactorImpl<T, K>(setterFactory);
    }
}

