/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.context.MappingContextFactory;

public class ContextualMapper<S, T>
implements Mapper<S, T> {
    private final MappingContextFactory<S> mappingContextFactory;
    private final Mapper<S, T> delegate;

    public ContextualMapper(Mapper<S, T> delegate, MappingContextFactory<S> mappingContextFactory) {
        this.delegate = delegate;
        this.mappingContextFactory = mappingContextFactory;
    }

    public MappingContext<S> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }

    @Override
    public T map(S source) throws MappingException {
        return this.delegate.map(source, this.mappingContextFactory.newContext());
    }

    @Override
    public T map(S source, MappingContext<? super S> context) throws MappingException {
        return this.delegate.map((S)source, context);
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        this.delegate.mapTo((S)source, target, context);
    }
}

