/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.util.Iterator;
import java.util.stream.Stream;
import org.sfm.map.FieldKey;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.SetRowMapper;
import org.sfm.map.mapper.MapperCache;
import org.sfm.map.mapper.MapperKey;
import org.sfm.map.mapper.MapperKeyComparator;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;
import org.sfm.utils.UnaryFactory;
import org.sfm.utils.UnaryFactoryWithException;

public class DynamicSetRowMapper<R, S, T, E extends Exception, K extends FieldKey<K>>
implements SetRowMapper<R, S, T, E> {
    private final MapperCache<K, SetRowMapper<R, S, T, E>> mapperCache;
    private final UnaryFactory<MapperKey<K>, SetRowMapper<R, S, T, E>> mapperFactory;
    private final UnaryFactoryWithException<R, MapperKey<K>, E> mapperKeyFromRow;
    private final UnaryFactoryWithException<S, MapperKey<K>, E> mapperKeyFromSet;

    public DynamicSetRowMapper(UnaryFactory<MapperKey<K>, SetRowMapper<R, S, T, E>> mapperFactory, UnaryFactoryWithException<R, MapperKey<K>, E> mapperKeyFromRow, UnaryFactoryWithException<S, MapperKey<K>, E> mapperKeyFromSet, MapperKeyComparator<K> keyComparator) {
        this.mapperFactory = mapperFactory;
        this.mapperKeyFromRow = mapperKeyFromRow;
        this.mapperKeyFromSet = mapperKeyFromSet;
        this.mapperCache = new MapperCache(keyComparator);
    }

    @Override
    public final T map(R row) throws MappingException {
        try {
            return this.getMapperFromRow(row).map(row);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            return null;
        }
    }

    @Override
    public final T map(R row, MappingContext<? super R> context) throws MappingException {
        try {
            return this.getMapperFromRow(row).map((R)row, context);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            return null;
        }
    }

    @Override
    public final void mapTo(R row, T target, MappingContext<? super R> context) throws Exception {
        this.getMapperFromRow(row).mapTo((R)row, target, context);
    }

    @Override
    public final Iterator<T> iterator(S rs) throws E, MappingException {
        return this.getMapperFromSet(rs).iterator(rs);
    }

    @Override
    public final Stream<T> stream(S set) throws E, MappingException {
        return this.getMapperFromSet(set).stream(set);
    }

    @Override
    public final <H extends RowHandler<? super T>> H forEach(S set, H handler) throws E, MappingException {
        return this.getMapperFromSet(set).forEach(set, handler);
    }

    @Override
    public final MappingContext<? super R> newMappingContext(R set) throws E {
        return this.getMapperFromRow(set).newMappingContext(set);
    }

    public String toString() {
        return "DynamicMapper{mapperFactory=" + this.mapperFactory + ", " + this.mapperCache + '}';
    }

    private SetRowMapper<R, S, T, E> getMapperFromSet(S set) throws E {
        return this.getMapper(this.mapperKeyFromSet.newInstance(set));
    }

    private SetRowMapper<R, S, T, E> getMapperFromRow(R row) throws E {
        return this.getMapper(this.mapperKeyFromRow.newInstance(row));
    }

    public SetRowMapper<R, S, T, E> getMapper(MapperKey<K> key) throws E {
        SetRowMapper<R, S, T, E> mapper = this.mapperCache.get(key);
        if (mapper == null) {
            mapper = this.mapperFactory.newInstance(key);
            this.mapperCache.add(key, mapper);
        }
        return mapper;
    }
}

