/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.jdbc.impl.getter.MapperGetterAdapter;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.Mapper;
import org.sfm.map.MapperBuildingException;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.DefaultValueProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.GetterProperty;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.impl.FieldErrorHandlerMapper;
import org.sfm.map.impl.fieldmapper.ConstantSourceFieldMapperFactory;
import org.sfm.map.impl.fieldmapper.ConstantSourceFieldMapperFactoryImpl;
import org.sfm.map.impl.fieldmapper.MapperFieldMapper;
import org.sfm.map.mapper.KeyFactory;
import org.sfm.map.mapper.MapperImpl;
import org.sfm.map.mapper.MapperSource;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.mapper.PropertyMappingsBuilder;
import org.sfm.map.mapper.PropertyWithSetter;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorDefinitions;
import org.sfm.reflect.InstantiatorFactory;
import org.sfm.reflect.InstantiatorOnGetter;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.ConstantGetter;
import org.sfm.reflect.impl.NullGetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ConstructorPropertyMeta;
import org.sfm.reflect.meta.DefaultPropertyNameMatcher;
import org.sfm.reflect.meta.DirectClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.SubPropertyMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.Asserts;
import org.sfm.utils.BiConsumer;
import org.sfm.utils.ErrorDoc;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;
import org.sfm.utils.Named;
import org.sfm.utils.Predicate;

public final class FieldMapperMapperBuilder<S, T, K extends FieldKey<K>> {
    private static final FieldKey[] FIELD_KEYS = new FieldKey[0];
    private final Type target;
    private final ConstantSourceFieldMapperFactory<S, K> fieldMapperFactory;
    protected final PropertyMappingsBuilder<T, K, FieldMapperColumnDefinition<K>> propertyMappingsBuilder;
    protected final ReflectionService reflectionService;
    private final List<FieldMapper<S, T>> additionalMappers = new ArrayList<FieldMapper<S, T>>();
    private final MapperSource<? super S, K> mapperSource;
    private final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder;
    private final KeyFactory<K> keyFactory;

    public FieldMapperMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory) throws MapperBuildingException {
        this.mapperSource = Asserts.requireNonNull("fieldMapperSource", mapperSource);
        this.mapperConfig = Asserts.requireNonNull("mapperConfig", mapperConfig);
        this.mappingContextFactoryBuilder = mappingContextFactoryBuilder;
        this.fieldMapperFactory = new ConstantSourceFieldMapperFactoryImpl<S, K>(mapperSource.getterFactory());
        this.keyFactory = keyFactory;
        this.propertyMappingsBuilder = new PropertyMappingsBuilder(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler(), new PropertyWithSetter());
        this.target = Asserts.requireNonNull("classMeta", classMeta).getType();
        this.reflectionService = Asserts.requireNonNull("classMeta", classMeta).getReflectionService();
    }

    public final FieldMapperMapperBuilder<S, T, K> addMapping(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        FieldMapperColumnDefinition<K> composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = composedDefinition.rename(key);
        if (columnDefinition.getCustomFieldMapper() != null) {
            this.addMapper(columnDefinition.getCustomFieldMapper());
        } else {
            PropertyMeta property = this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
            if (property != null && composedDefinition.isKey() && composedDefinition.keyAppliesTo().test(property)) {
                this.mappingContextFactoryBuilder.addKey(key);
            }
        }
        return this;
    }

    public Mapper<S, T> mapper() {
        Mapper<Object, T> mapper;
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, new BiConsumer<Predicate<? super K>, DefaultValueProperty>(){

            @Override
            public void accept(Predicate<? super K> predicate, DefaultValueProperty columnProperty) {
                if (FieldMapperMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)((Object)predicate)).getName();
                    GetterProperty getterProperty = new GetterProperty(new ConstantGetter(columnProperty.getValue()), columnProperty.getValue().getClass()){};
                    FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(columnProperty, getterProperty);
                    FieldMapperMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent(FieldMapperMapperBuilder.this.keyFactory.newKey(name, FieldMapperMapperBuilder.this.propertyMappingsBuilder.maxIndex() + 1), columnDefinition);
                }
            }
        });
        FieldMapper<S, T>[] fields = this.fields();
        Tuple2<FieldMapper<S, T>[], Instantiator<S, T>> constructorFieldMappersAndInstantiator = this.getConstructorFieldMappersAndInstantiator();
        if (this.isEligibleForAsmMapper()) {
            try {
                mapper = this.reflectionService.getAsmFactory().createMapper(this.getKeys(), fields, constructorFieldMappersAndInstantiator.first(), constructorFieldMappersAndInstantiator.second(), this.mapperSource.source(), this.getTargetClass());
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (Mapper)ErrorHelper.rethrow(e);
                }
                mapper = new MapperImpl<S, T>(fields, constructorFieldMappersAndInstantiator.first(), constructorFieldMappersAndInstantiator.second());
            }
        } else {
            mapper = new MapperImpl<S, T>(fields, constructorFieldMappersAndInstantiator.first(), constructorFieldMappersAndInstantiator.second());
        }
        return mapper;
    }

    public boolean hasJoin() {
        return this.mappingContextFactoryBuilder.isRoot() && !this.mappingContextFactoryBuilder.hasNoDependentKeys();
    }

    private Class<T> getTargetClass() {
        return TypeHelper.toClass(this.target);
    }

    private Tuple2<FieldMapper<S, T>[], Instantiator<S, T>> getConstructorFieldMappersAndInstantiator() throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            Tuple2<Map<Parameter, Getter<S, ?>>, FieldMapper<S, T>[]> constructorInjections = this.constructorInjections();
            Map injections = constructorInjections.first();
            Instantiator<? super S, T> instantiator = instantiatorFactory.getInstantiator(this.mapperSource.source(), this.target, this.propertyMappingsBuilder, injections, this.mapperSource.getterFactory());
            return new Tuple2<FieldMapper<S, T>[], Instantiator<S, T>>(constructorInjections.second(), instantiator);
        }
        catch (Exception e) {
            return (Tuple2)ErrorHelper.rethrow(e);
        }
    }

    private Tuple2<Map<Parameter, Getter<? super S, ?>>, FieldMapper<S, T>[]> constructorInjections() {
        final HashMap injections = new HashMap();
        ArrayList<FieldMapper<S, T>> fieldMappers = new ArrayList<FieldMapper<S, T>>();
        this.propertyMappingsBuilder.forEachConstructorProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            @Override
            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
                PropertyMeta pm = t.getPropertyMeta();
                ConstructorPropertyMeta cProp = (ConstructorPropertyMeta)pm;
                Parameter parameter = cProp.getParameter();
                injections.put(parameter, FieldMapperMapperBuilder.this.getterFor(t));
            }
        });
        for (Tuple2<PropertyMeta<T, ?>, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>> e : this.getSubPropertyPerOwner()) {
            if (!e.first().isConstructorProperty()) continue;
            List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties = e.second();
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(e.first(), properties);
            Mapper<S, ?> mapper = this.subPropertyMapper(e.first(), properties, currentBuilder);
            ConstructorPropertyMeta meta = (ConstructorPropertyMeta)e.first();
            injections.put(meta.getParameter(), this.newMapperGetterAdapter(mapper, currentBuilder));
            fieldMappers.add(this.newMapperFieldMapper(properties, meta, mapper, currentBuilder));
        }
        return new Tuple2(injections, fieldMappers.toArray(new FieldMapper[0]));
    }

    private MappingContextFactoryBuilder getMapperContextFactoryBuilder(PropertyMeta<?, ?> owner, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties) {
        List<K> subKeys = this.getSubKeys(properties);
        return this.mappingContextFactoryBuilder.newBuilder(subKeys, owner);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties, PropertyMeta<T, ?> meta, Mapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        Getter<T, ?> getter = meta.getGetter();
        if (mappingContextFactoryBuilder.isEmpty() && getter instanceof NullGetter) {
            throw new MapperBuildingException("Cannot get a getter on " + meta + " needed to work with join " + mappingContextFactoryBuilder);
        }
        MapperFieldMapper fieldMapper = new MapperFieldMapper(mapper, meta.getSetter(), getter, mappingContextFactoryBuilder.nullChecker(), mappingContextFactoryBuilder.breakDetectorGetter());
        return this.wrapFieldMapperWithErrorHandler(properties.get(0), fieldMapper);
    }

    private <P> Getter<S, P> newMapperGetterAdapter(Mapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> builder) {
        return new MapperGetterAdapter(mapper, builder.nullChecker());
    }

    private <P> void addMapping(K columnKey, FieldMapperColumnDefinition<K> columnDefinition, PropertyMeta<T, P> prop) {
        this.propertyMappingsBuilder.addProperty(columnKey, columnDefinition, prop);
    }

    private FieldMapper<S, T>[] fields() {
        final ArrayList<FieldMapper> fields = new ArrayList<FieldMapper>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            @Override
            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null || meta instanceof DirectClassMeta.DirectPropertyMeta) {
                    return;
                }
                if (!meta.isConstructorProperty() && !meta.isSubProperty()) {
                    fields.add(FieldMapperMapperBuilder.this.newFieldMapper(t));
                }
            }
        });
        for (Tuple2<PropertyMeta<T, ?>, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>> tuple2 : this.getSubPropertyPerOwner()) {
            if (tuple2.first().isConstructorProperty()) continue;
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(tuple2.first(), tuple2.second());
            Mapper<S, ?> mapper = this.subPropertyMapper(tuple2.first(), tuple2.second(), currentBuilder);
            fields.add(this.newMapperFieldMapper(tuple2.second(), tuple2.first(), mapper, currentBuilder));
        }
        for (FieldMapper fieldMapper : this.additionalMappers) {
            fields.add(fieldMapper);
        }
        return fields.toArray(new FieldMapper[0]);
    }

    private List<Tuple2<PropertyMeta<T, ?>, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>>> getSubPropertyPerOwner() {
        final ArrayList subPropertiesList = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            @Override
            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null) {
                    return;
                }
                if (meta.isSubProperty()) {
                    this.addSubProperty(t, (SubPropertyMeta)meta, t.getColumnKey());
                }
            }

            private <P> void addSubProperty(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm, SubPropertyMeta<T, ?, ?> subPropertyMeta, K key) {
                PropertyMeta propertyOwner = subPropertyMeta.getOwnerProperty();
                List props = this.getList(propertyOwner);
                if (props == null) {
                    props = new ArrayList();
                    subPropertiesList.add(new Tuple2(propertyOwner, props));
                }
                props.add(pm);
            }

            private List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> getList(PropertyMeta<?, ?> owner) {
                for (Tuple2 tuple : subPropertiesList) {
                    if (!((PropertyMeta)tuple.first()).equals(owner)) continue;
                    return (List)tuple.second();
                }
                return null;
            }
        });
        return subPropertiesList;
    }

    private <P> Mapper<S, P> subPropertyMapper(PropertyMeta<T, P> owner, List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        FieldMapperMapperBuilder<S, P, K> builder = this.newSubBuilder(owner.getPropertyClassMeta(), mappingContextFactoryBuilder);
        for (PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm : properties) {
            SubPropertyMeta propertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            PropertyMeta subProperty = propertyMeta.getSubProperty();
            super.addMapping(pm.getColumnKey(), pm.getColumnDefinition(), subProperty);
        }
        return builder.mapper();
    }

    protected <P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> t) {
        FieldMapper<Object, Object> fieldMapper = t.getColumnDefinition().getCustomFieldMapper();
        if (fieldMapper == null) {
            fieldMapper = this.fieldMapperFactory.newFieldMapper(t, this.mappingContextFactoryBuilder, this.mapperConfig.mapperBuilderErrorHandler());
        }
        return this.wrapFieldMapperWithErrorHandler(t, fieldMapper);
    }

    private <P> FieldMapper<S, T> wrapFieldMapperWithErrorHandler(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> t, FieldMapper<S, T> fieldMapper) {
        if (fieldMapper != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return new FieldErrorHandlerMapper<S, T, K>(t.getColumnKey(), fieldMapper, this.mapperConfig.fieldMapperErrorHandler());
        }
        return fieldMapper;
    }

    private Getter<? super S, ?> getterFor(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> t) {
        Getter<Object, Object> getter = t.getColumnDefinition().getCustomGetter();
        if (getter == null) {
            getter = this.mapperSource.getterFactory().newGetter(t.getPropertyMeta().getPropertyType(), t.getColumnKey(), t.getColumnDefinition());
        }
        if (getter == null) {
            ClassMeta<?> classMeta = t.getPropertyMeta().getPropertyClassMeta();
            InstantiatorDefinitions.CompatibilityScorer scorer = InstantiatorDefinitions.getCompatibilityScorer(t.getColumnKey());
            InstantiatorDefinition id = InstantiatorDefinitions.lookForCompatibleOneArgument(classMeta.getInstantiatorDefinitions(), scorer);
            if (id != null) {
                Parameter parameter = id.getParameters()[0];
                PropertyMeta pm = classMeta.newPropertyFinder().findProperty(DefaultPropertyNameMatcher.exact(parameter.getName()));
                PropertyMapping propertyMapping = t.propertyMeta(pm);
                getter = this.getterFor(propertyMapping);
                if (getter != null) {
                    Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id);
                    getter = new InstantiatorOnGetter(instantiator, getter);
                }
            }
        }
        if (getter == null) {
            this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound("Could not find getter for " + t.getColumnKey() + " type " + t.getPropertyMeta().getPropertyType() + " See " + ErrorDoc.toUrl("FMMB_GETTER_NOT_FOUND"));
        }
        return getter;
    }

    public void addMapper(FieldMapper<S, T> mapper) {
        this.additionalMappers.add(mapper);
    }

    private <ST> FieldMapperMapperBuilder<S, ST, K> newSubBuilder(ClassMeta<ST> classMeta, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        return new FieldMapperMapperBuilder<S, ST, K>(this.mapperSource, classMeta, this.mapperConfig, mappingContextFactoryBuilder, this.keyFactory);
    }

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(FIELD_KEYS);
    }

    private boolean isEligibleForAsmMapper() {
        return this.reflectionService.isAsmActivated() && this.propertyMappingsBuilder.size() < this.mapperConfig.asmMapperNbFieldsLimit();
    }

    private List<K> getSubKeys(List<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>> properties) {
        ArrayList<K> keys = new ArrayList<K>();
        for (PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm : properties) {
            SubPropertyMeta subPropertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            if (!pm.getColumnDefinition().isKey() || !pm.getColumnDefinition().keyAppliesTo().test(subPropertyMeta.getSubProperty())) continue;
            keys.add(pm.getColumnKey());
        }
        return keys;
    }
}

