/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.utils.Enumarable;
import org.sfm.utils.ErrorHelper;

public class JoinMapperEnumarable<S, T>
implements Enumarable<T> {
    private final Mapper<S, T> mapper;
    private final MappingContext<? super S> mappingContext;
    private final Enumarable<S> sourceEnumarable;
    private T currentValue;
    private T nextValue;

    public JoinMapperEnumarable(Mapper<S, T> mapper, MappingContext<? super S> mappingContext, Enumarable<S> sourceEnumarable) {
        this.mapper = mapper;
        this.mappingContext = mappingContext;
        this.sourceEnumarable = sourceEnumarable;
    }

    @Override
    public boolean next() {
        try {
            this.currentValue = this.nextValue;
            this.nextValue = null;
            while (this.sourceEnumarable.next()) {
                S source = this.sourceEnumarable.currentValue();
                this.mappingContext.handle(source);
                if (this.mappingContext.rootBroke()) {
                    if (this.currentValue == null) {
                        this.currentValue = this.mapper.map((S)source, this.mappingContext);
                        continue;
                    }
                    this.nextValue = this.mapper.map((S)source, this.mappingContext);
                    return true;
                }
                this.mapper.mapTo((S)source, this.currentValue, this.mappingContext);
            }
            return this.currentValue != null;
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            return false;
        }
    }

    @Override
    public T currentValue() {
        return this.currentValue;
    }

    public String toString() {
        return "JoinJdbcMapper{jdbcMapper=" + this.mapper + '}';
    }
}

