/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.sfm.map.FieldKey;
import org.sfm.map.mapper.MapperKey;
import org.sfm.map.mapper.MapperKeyComparator;

public final class MapperCache<K extends FieldKey<K>, M> {
    private static final int SIZE_THRESHOLD = 60;
    private final AtomicReference<SortedEntries<K>> sortedEntries;

    public MapperCache(MapperKeyComparator<K> comparator) {
        this.sortedEntries = new AtomicReference<SortedEntries<K>>(new SortedEntries<K>(0, comparator));
    }

    public void add(MapperKey<K> key, M mapper) {
        int i;
        int insertionPoint;
        SortedEntries<K> newSortedEntries;
        SortedEntries<K> sortedEntries;
        do {
            if ((i = ((SortedEntries)(sortedEntries = this.sortedEntries.get())).findInsertionPoint(key)) < 0) continue;
            if (!key.equals(((SortedEntries)sortedEntries).keys[i])) {
                throw new IllegalStateException("Comparator find key " + key + " to be equal to " + ((SortedEntries)sortedEntries).keys[i] + " but is not");
            }
            return;
        } while (!this.sortedEntries.compareAndSet(sortedEntries, newSortedEntries = sortedEntries.insertEntry(key, mapper, insertionPoint = -1 - i)));
    }

    public M get(MapperKey<K> key) {
        return (M)this.sortedEntries.get().search(key);
    }

    public String toString() {
        return "MapperCache{sortedEntries=" + Arrays.toString(((SortedEntries)this.sortedEntries.get()).keys) + '}';
    }

    private static final class SortedEntries<K extends FieldKey<K>> {
        private final MapperKey<K>[] keys;
        private final Object[] values;
        private final boolean bsearch;
        private final MapperKeyComparator<K> comparator;

        SortedEntries(int size, MapperKeyComparator<K> comparator) {
            this.comparator = comparator;
            this.keys = new MapperKey[size];
            this.values = new Object[size];
            this.bsearch = size > 60;
        }

        SortedEntries(MapperKey<K>[] keys, Object[] values, MapperKeyComparator<K> comparator) {
            this.keys = keys;
            this.values = values;
            this.comparator = comparator;
            this.bsearch = keys.length > 60;
        }

        Object search(MapperKey<K> key) {
            int i = this.findKey(key);
            if (i >= 0) {
                return this.values[i];
            }
            return null;
        }

        int findKey(MapperKey<K> key) {
            if (this.bsearch) {
                return Arrays.binarySearch(this.keys, key, this.comparator);
            }
            return this.iFindKey(key);
        }

        private int iFindKey(MapperKey<K> key) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                return i;
            }
            return -this.keys.length - 1;
        }

        private int findInsertionPoint(MapperKey<K> key) {
            if (this.comparator == null) {
                return this.iFindKey(key);
            }
            return Arrays.binarySearch(this.keys, key, this.comparator);
        }

        SortedEntries<K> insertEntry(MapperKey<K> key, Object mapper, int insertionPoint) {
            SortedEntries<K> newEntries = new SortedEntries<K>(Arrays.copyOf(this.keys, this.keys.length + 1), Arrays.copyOf(this.values, this.values.length + 1), this.comparator);
            System.arraycopy(newEntries.keys, insertionPoint, newEntries.keys, insertionPoint + 1, this.keys.length - insertionPoint);
            System.arraycopy(newEntries.values, insertionPoint, newEntries.values, insertionPoint + 1, this.values.length - insertionPoint);
            newEntries.keys[insertionPoint] = key;
            newEntries.values[insertionPoint] = mapper;
            return newEntries;
        }
    }
}

