/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.util.Comparator;
import org.sfm.csv.CsvColumnKey;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.map.FieldKey;
import org.sfm.map.mapper.MapperKey;

public abstract class MapperKeyComparator<K extends FieldKey<K>>
implements Comparator<MapperKey<K>> {
    public static final MapperKeyComparator<CsvColumnKey> csvColumnKeyComparator() {
        return new CsvColumnKeyMapperKeyComparator();
    }

    public static final MapperKeyComparator<JdbcColumnKey> jdbcColumnKeyComparator() {
        return new JdbcColumnKeyMapperKeyComparator();
    }

    private static final class JdbcColumnKeyMapperKeyComparator
    extends MapperKeyComparator<JdbcColumnKey> {
        private JdbcColumnKeyMapperKeyComparator() {
        }

        @Override
        public int compare(MapperKey<JdbcColumnKey> m1, MapperKey<JdbcColumnKey> m2) {
            JdbcColumnKey[] keys2;
            JdbcColumnKey[] keys1 = (JdbcColumnKey[])m1.getColumns();
            int d = keys1.length - (keys2 = (JdbcColumnKey[])m2.getColumns()).length;
            if (d != 0) {
                return d;
            }
            return this.compareKeys(keys1, keys2);
        }

        private int compareKeys(JdbcColumnKey[] keys1, JdbcColumnKey[] keys2) {
            for (int i = 0; i < keys1.length; ++i) {
                int d = this.compare(keys1[i], keys2[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        @Override
        protected int compare(JdbcColumnKey k1, JdbcColumnKey k2) {
            int d = k1.getIndex() - k2.getIndex();
            if (d != 0) {
                return d;
            }
            d = k1.getName().compareTo(k2.getName());
            if (d != 0) {
                return d;
            }
            return k1.getSqlType() - k2.getSqlType();
        }
    }

    private static final class CsvColumnKeyMapperKeyComparator
    extends MapperKeyComparator<CsvColumnKey> {
        private CsvColumnKeyMapperKeyComparator() {
        }

        @Override
        public int compare(MapperKey<CsvColumnKey> m1, MapperKey<CsvColumnKey> m2) {
            CsvColumnKey[] keys2;
            CsvColumnKey[] keys1 = (CsvColumnKey[])m1.getColumns();
            int d = keys1.length - (keys2 = (CsvColumnKey[])m2.getColumns()).length;
            if (d != 0) {
                return d;
            }
            return this.compareKeys(keys1, keys2);
        }

        private int compareKeys(CsvColumnKey[] keys1, CsvColumnKey[] keys2) {
            for (int i = 0; i < keys1.length; ++i) {
                int d = this.compare(keys1[i], keys2[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        @Override
        private int compare(CsvColumnKey k1, CsvColumnKey k2) {
            int d = k1.getIndex() - k2.getIndex();
            if (d != 0) {
                return d;
            }
            return k1.getName().compareTo(k2.getName());
        }
    }
}

