/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.sfm.map.FieldKey;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.MapperBuildingException;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DirectClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcherFactory;
import org.sfm.utils.ForEachCallBack;
import org.sfm.utils.Predicate;

public final class PropertyMappingsBuilder<T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> {
    protected final PropertyFinder<T> propertyFinder;
    protected final List<PropertyMapping<T, ?, K, D>> properties = new ArrayList();
    protected final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final ClassMeta<T> classMeta;
    protected boolean modifiable = true;
    private final Predicate<PropertyMeta<?, ?>> isValidMeta;

    public PropertyMappingsBuilder(ClassMeta<T> classMeta, PropertyNameMatcherFactory propertyNameMatcherFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler, Predicate<PropertyMeta<?, ?>> isValidMeta) throws MapperBuildingException {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.isValidMeta = isValidMeta;
        this.propertyFinder = classMeta.newPropertyFinder();
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.classMeta = classMeta;
    }

    public <P> PropertyMeta<T, P> addProperty(K key, D columnDefinition) {
        if (!this.modifiable) {
            throw new IllegalStateException("Builder not modifiable");
        }
        if (((ColumnDefinition)columnDefinition).ignore()) {
            this.properties.add(null);
            return null;
        }
        PropertyMeta<T, P> prop = this.addPropertyIfPresent(key, columnDefinition);
        if (prop == null) {
            this.mapperBuilderErrorHandler.propertyNotFound(this.classMeta.getType(), ((FieldKey)key).getName());
            return null;
        }
        return prop;
    }

    public <P> PropertyMeta<T, P> addPropertyIfPresent(K key, D columnDefinition) {
        PropertyMeta prop = this.propertyFinder.findProperty(this.propertyNameMatcherFactory.newInstance((FieldKey<?>)key));
        if (prop == null || !this.isValidMeta.test(prop)) {
            this.properties.add(null);
            return null;
        }
        this.addProperty(key, columnDefinition, prop);
        return prop;
    }

    public <P> void addProperty(K key, D columnDefinition, PropertyMeta<T, P> prop) {
        if (((ColumnDefinition)columnDefinition).hasCustomSource()) {
            Type type = prop.getPropertyType();
            if (!this.checkTypeCompatibility(key, ((ColumnDefinition)columnDefinition).getCustomSourceReturnType(), type)) {
                this.properties.add(null);
                return;
            }
        }
        this.properties.add(new PropertyMapping<T, P, K, D>(prop, key, columnDefinition));
    }

    private boolean checkTypeCompatibility(K key, Type customSourceReturnType, Type propertyMetaType) {
        if (customSourceReturnType == null) {
            return true;
        }
        if (!this.areCompatible(propertyMetaType, customSourceReturnType)) {
            this.mapperBuilderErrorHandler.customFieldError((FieldKey<?>)key, "Incompatible customReader type " + customSourceReturnType + " expected " + propertyMetaType);
            return false;
        }
        return true;
    }

    private boolean areCompatible(Type propertyMetaType, Type customSourceReturnType) {
        Class<?> propertyMetaClass = TypeHelper.toBoxedClass(TypeHelper.toClass(propertyMetaType));
        Class<?> customSourceReturnClass = TypeHelper.toBoxedClass(TypeHelper.toClass(customSourceReturnType));
        return propertyMetaClass.isAssignableFrom(customSourceReturnClass);
    }

    public List<K> getKeys() {
        this.modifiable = false;
        ArrayList<K> keys = new ArrayList<K>(this.properties.size());
        for (PropertyMapping<T, ?, K, D> propMapping : this.properties) {
            if (propMapping != null) {
                keys.add(propMapping.getColumnKey());
                continue;
            }
            keys.add(null);
        }
        return keys;
    }

    public void forEachConstructorProperties(ForEachCallBack<PropertyMapping<T, ?, K, D>> handler) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K, D> property : this.properties) {
            PropertyMeta<T, ?> propertyMeta;
            if (property == null || (propertyMeta = property.getPropertyMeta()) == null || !propertyMeta.isConstructorProperty()) continue;
            handler.handle(property);
        }
    }

    public <H extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> H forEachProperties(H handler) {
        return this.forEachProperties(handler, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> F forEachProperties(F handler, int start) {
        return this.forEachProperties(handler, start, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K, D>>> F forEachProperties(F handler, int start, int end) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K, D> prop : this.properties) {
            if (prop == null || ((FieldKey)prop.getColumnKey()).getIndex() < start && start != -1 || ((FieldKey)prop.getColumnKey()).getIndex() >= end && end != -1) continue;
            handler.handle(prop);
        }
        return handler;
    }

    public PropertyFinder<T> getPropertyFinder() {
        this.modifiable = false;
        return this.propertyFinder;
    }

    public int size() {
        return this.properties.size();
    }

    public PropertyMapping<T, ?, K, D> get(int i) {
        this.modifiable = false;
        return this.properties.get(i);
    }

    public boolean isDirectProperty() {
        return this.properties.size() == 1 && this.properties.get(0) != null && this.properties.get(0).getPropertyMeta() instanceof DirectClassMeta.DirectPropertyMeta;
    }

    public int maxIndex() {
        int i = -1;
        for (PropertyMapping<T, ?, K, D> prop : this.properties) {
            if (prop == null) continue;
            i = Math.max(i, ((FieldKey)prop.getColumnKey()).getIndex());
        }
        return i;
    }

    public boolean hasKey(Predicate<? super K> predicate) {
        for (PropertyMapping<T, ?, K, D> propMapping : this.properties) {
            if (propMapping == null || !predicate.test(propMapping.getColumnKey())) continue;
            return true;
        }
        return false;
    }
}

