/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.mapper;

import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.SetRowMapper;
import org.sfm.map.context.MappingContextFactory;
import org.sfm.map.impl.StaticMapperEnumarable;
import org.sfm.map.mapper.AbstractEnumarableMapper;
import org.sfm.utils.Enumarable;
import org.sfm.utils.UnaryFactory;

public class StaticSetRowMapper<R, S, T, E extends Exception>
extends AbstractEnumarableMapper<S, T, E>
implements SetRowMapper<R, S, T, E> {
    private final Mapper<R, T> mapper;
    private final MappingContextFactory<? super R> mappingContextFactory;
    private final UnaryFactory<S, Enumarable<R>> enumarableFactory;

    public StaticSetRowMapper(Mapper<R, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super R> mappingContextFactory, UnaryFactory<S, Enumarable<R>> enumarableFactory) {
        super(errorHandler);
        this.mapper = mapper;
        this.mappingContextFactory = mappingContextFactory;
        this.enumarableFactory = enumarableFactory;
    }

    @Override
    public final T map(R rs) throws MappingException {
        return this.mapper.map(rs);
    }

    @Override
    public final T map(R rs, MappingContext<? super R> context) throws MappingException {
        return this.mapper.map(rs, context);
    }

    @Override
    public final void mapTo(R rs, T target, MappingContext<? super R> context) throws Exception {
        this.mapper.mapTo(rs, target, context);
    }

    @Override
    public final MappingContext<? super R> newMappingContext(R set) throws E {
        return this.mappingContextFactory.newContext();
    }

    public String toString() {
        return "StaticSetRowMapper{" + this.mapper + '}';
    }

    @Override
    protected final Enumarable<T> newEnumarableOfT(S source) throws E {
        return new StaticMapperEnumarable<R, T>(this.mapper, this.mappingContextFactory.newContext(), this.enumarableFactory.newInstance(source));
    }
}

