/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Arrays;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;

public final class ExecutableInstantiatorDefinition
implements InstantiatorDefinition {
    private final Member executable;
    private final Parameter[] parameters;
    private final InstantiatorDefinition.Type type;

    public ExecutableInstantiatorDefinition(Member executable, Parameter ... parameters) {
        this.executable = executable;
        this.parameters = parameters;
        this.type = executable instanceof Constructor ? InstantiatorDefinition.Type.CONSTRUCTOR : InstantiatorDefinition.Type.METHOD;
    }

    public Member getExecutable() {
        return this.executable;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasParam(Parameter param) {
        for (Parameter p : this.parameters) {
            if (!p.equals(param)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InstantiatorDefinition.Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.executable.getName();
    }

    public String toString() {
        return "InstantiatorDefinition{executable=" + this.executable + ", parameters=" + Arrays.toString(this.parameters) + '}';
    }
}

