/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.sfm.reflect.TypeHelper;

public class GetterHelper {
    public static final int SYNTHETIC = 4096;

    public static boolean isPublicMember(int modifiers) {
        return !Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (modifiers & 0x1000) == 0;
    }

    public static boolean methodNameMatchesProperty(String name, String property) {
        if (name.length() > 3 && name.startsWith("get")) {
            return name.regionMatches(true, 3, property, 0, property.length());
        }
        if (name.length() > 2 && name.startsWith("is")) {
            return name.regionMatches(true, 2, property, 0, property.length());
        }
        return name.equalsIgnoreCase(property);
    }

    public static boolean fieldModifiersMatches(int modifiers) {
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    public static boolean fieldNameMatchesProperty(String name, String property) {
        return name.equalsIgnoreCase(property);
    }

    public static String getPropertyNameFromMethodName(String name) {
        if (name.startsWith("get") && name.length() > 3) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (name.startsWith("is") && name.length() > 2) {
            return name.substring(2, 3).toLowerCase() + name.substring(3);
        }
        return name;
    }

    public static boolean isGetter(Method method) {
        return GetterHelper.isPublicMember(method.getModifiers()) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0) && !method.getReturnType().equals(Void.TYPE) && !GetterHelper.isToString(method) && !GetterHelper.isHashcode(method);
    }

    private static boolean isToString(Method method) {
        return method.getName() == "toString" && method.getReturnType().equals(String.class) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0);
    }

    private static boolean isHashcode(Method method) {
        return method.getName() == "hashCode" && method.getReturnType().equals(Integer.TYPE) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0);
    }

    public static boolean isCompatible(Type targetType, Type returnType) {
        return TypeHelper.isAssignable(targetType, returnType);
    }
}

