/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.impl.CalculateMaxIndex;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.mapper.PropertyMappingsBuilder;
import org.sfm.reflect.BuilderInstantiatorDefinition;
import org.sfm.reflect.ExecutableInstantiatorDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.GetterInstantiator;
import org.sfm.reflect.IdentityGetter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorDefinitions;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmFactory;
import org.sfm.reflect.impl.BuilderInstantiator;
import org.sfm.reflect.impl.EmptyConstructorInstantiator;
import org.sfm.reflect.impl.EmptyStaticMethodInstantiator;
import org.sfm.reflect.impl.InjectConstructorInstantiator;
import org.sfm.reflect.impl.InjectStaticMethodInstantiator;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;

public class InstantiatorFactory {
    private final AsmFactory asmFactory;
    private final boolean failOnAsmError;

    public InstantiatorFactory(AsmFactory asmFactory) {
        this(asmFactory, false);
    }

    public InstantiatorFactory(AsmFactory asmFactory, boolean faileOnAsmError) {
        this.asmFactory = asmFactory;
        this.failOnAsmError = faileOnAsmError;
    }

    public <S, T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> Instantiator<S, T> getInstantiator(Type source, Type target, PropertyMappingsBuilder<T, K, D> propertyMappingsBuilder, Map<Parameter, Getter<? super S, ?>> constructorParameterGetterMap, GetterFactory<? super S, K> getterFactory) throws NoSuchMethodException {
        return this.getInstantiator(source, target, propertyMappingsBuilder, constructorParameterGetterMap, getterFactory, true);
    }

    public <S, T, K extends FieldKey<K>, D extends ColumnDefinition<K, D>> Instantiator<S, T> getInstantiator(Type source, Type target, PropertyMappingsBuilder<T, K, D> propertyMappingsBuilder, Map<Parameter, Getter<? super S, ?>> constructorParameterGetterMap, final GetterFactory<? super S, K> getterFactory, boolean useAsmIfEnabled) throws NoSuchMethodException {
        if (propertyMappingsBuilder.isDirectProperty()) {
            Getter getter = propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, D>>(){
                public Getter getter;

                @Override
                public void handle(PropertyMapping<T, ?, K, D> propertyMapping) {
                    this.getter = getterFactory.newGetter(propertyMapping.getPropertyMeta().getPropertyType(), propertyMapping.getColumnKey(), (ColumnDefinition<?, ?>)propertyMapping.getColumnDefinition());
                }
            }).getter;
            return new GetterInstantiator(getter);
        }
        if (TypeHelper.isArray(target)) {
            return this.getArrayInstantiator(TypeHelper.toClass(TypeHelper.getComponentTypeOfListOrArray(target)), propertyMappingsBuilder.forEachProperties(new CalculateMaxIndex<T, K, D>()).maxIndex + 1);
        }
        return this.getInstantiator(target, TypeHelper.toClass(source), propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions(), constructorParameterGetterMap, useAsmIfEnabled);
    }

    public <S, T> Instantiator<S, T> getInstantiator(Type target, Class<?> source, List<InstantiatorDefinition> constructors, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) throws SecurityException {
        InstantiatorDefinition instantiatorDefinition = InstantiatorFactory.getSmallerConstructor(constructors);
        if (instantiatorDefinition == null) {
            throw new IllegalArgumentException("No constructor available for " + target);
        }
        return this.getInstantiator(instantiatorDefinition, source, injections, useAsmIfEnabled);
    }

    public <S, T> Instantiator<S, T> getInstantiator(InstantiatorDefinition instantiatorDefinition, Class<?> source, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) {
        block14: {
            if (this.asmFactory != null && useAsmIfEnabled) {
                if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
                    ExecutableInstantiatorDefinition executableInstantiatorDefinition = (ExecutableInstantiatorDefinition)instantiatorDefinition;
                    Member executable = executableInstantiatorDefinition.getExecutable();
                    if (Modifier.isPublic(executable.getModifiers())) {
                        try {
                            return this.asmFactory.createInstantiator(source, executableInstantiatorDefinition, injections);
                        }
                        catch (Exception e) {
                            if (this.failOnAsmError) {
                                ErrorHelper.rethrow(e);
                            }
                        }
                    }
                } else {
                    try {
                        return this.asmFactory.createInstantiator(source, (BuilderInstantiatorDefinition)instantiatorDefinition, injections);
                    }
                    catch (Exception e) {
                        if (!this.failOnAsmError) break block14;
                        ErrorHelper.rethrow(e);
                    }
                }
            }
        }
        switch (instantiatorDefinition.getType()) {
            case CONSTRUCTOR: {
                return this.constructorInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case METHOD: {
                return this.methodInstantiator((ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            }
            case BUILDER: {
                return this.builderInstantiator((BuilderInstantiatorDefinition)instantiatorDefinition, injections, useAsmIfEnabled);
            }
        }
        throw new IllegalArgumentException("Unsupported executable type " + instantiatorDefinition);
    }

    private <S, T> Instantiator<S, T> builderInstantiator(BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, boolean useAsmIfEnabled) {
        Instantiator<? super S, T> buildInstantiator = this.getInstantiator(instantiatorDefinition.getBuilderInstantiator(), Void.class, new HashMap(), useAsmIfEnabled);
        ArrayList chainedArguments = new ArrayList();
        ArrayList unchainedArguments = new ArrayList();
        boolean i = false;
        for (Map.Entry<Parameter, Getter<S, ?>> e : injections.entrySet()) {
            Tuple2 arguments = new Tuple2(instantiatorDefinition.getSetters().get(e.getKey()), e.getValue());
            if (Void.TYPE.equals(arguments.first().getReturnType())) {
                unchainedArguments.add(arguments);
                continue;
            }
            chainedArguments.add(arguments);
        }
        return new BuilderInstantiator(buildInstantiator, chainedArguments.toArray(new Tuple2[0]), unchainedArguments.toArray(new Tuple2[0]), instantiatorDefinition.getBuildMethod());
    }

    private <S, T> Instantiator<S, T> methodInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        Method m = (Method)instantiatorDefinition.getExecutable();
        if (m.getParameterTypes().length == 0) {
            return new EmptyStaticMethodInstantiator(m);
        }
        return new InjectStaticMethodInstantiator(instantiatorDefinition, injections);
    }

    private <S, T> Instantiator<S, T> constructorInstantiator(ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) {
        Constructor c = (Constructor)instantiatorDefinition.getExecutable();
        if (c.getParameterTypes().length == 0) {
            return new EmptyConstructorInstantiator(c);
        }
        return new InjectConstructorInstantiator(instantiatorDefinition, injections);
    }

    public static InstantiatorDefinition getSmallerConstructor(List<InstantiatorDefinition> constructors) {
        if (constructors == null) {
            return null;
        }
        InstantiatorDefinition selectedConstructor = null;
        for (InstantiatorDefinition c : constructors) {
            if (selectedConstructor != null && InstantiatorDefinitions.COMPARATOR.compare(c, selectedConstructor) >= 0) continue;
            selectedConstructor = c;
        }
        return selectedConstructor;
    }

    public <S, T> Instantiator<S, T> getArrayInstantiator(Class<?> elementType, int length) {
        return new ArrayInstantiator(elementType, length);
    }

    public <S, T> Instantiator<S, T> getOneArgIdentityInstantiator(InstantiatorDefinition id) {
        HashMap injections = new HashMap();
        injections.put(id.getParameters()[0], new IdentityGetter());
        return this.getInstantiator(id, id.getParameters()[0].getType(), injections, true);
    }

    private static final class ArrayInstantiator<S, T>
    implements Instantiator<S, T> {
        private final Class<?> elementType;
        private final int length;

        public ArrayInstantiator(Class<?> elementType, int length) {
            this.elementType = elementType;
            this.length = length;
        }

        @Override
        public T newInstance(S s) throws Exception {
            return (T)Array.newInstance(this.elementType, this.length);
        }
    }
}

