/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterHelper;
import org.sfm.reflect.asm.AsmFactory;
import org.sfm.reflect.impl.FieldSetter;
import org.sfm.reflect.impl.MethodSetter;
import org.sfm.reflect.impl.NullSetter;
import org.sfm.reflect.primitive.BooleanFieldSetter;
import org.sfm.reflect.primitive.BooleanMethodSetter;
import org.sfm.reflect.primitive.BooleanSetter;
import org.sfm.reflect.primitive.ByteFieldSetter;
import org.sfm.reflect.primitive.ByteMethodSetter;
import org.sfm.reflect.primitive.ByteSetter;
import org.sfm.reflect.primitive.CharacterFieldSetter;
import org.sfm.reflect.primitive.CharacterMethodSetter;
import org.sfm.reflect.primitive.CharacterSetter;
import org.sfm.reflect.primitive.DoubleFieldSetter;
import org.sfm.reflect.primitive.DoubleMethodSetter;
import org.sfm.reflect.primitive.DoubleSetter;
import org.sfm.reflect.primitive.FloatFieldSetter;
import org.sfm.reflect.primitive.FloatMethodSetter;
import org.sfm.reflect.primitive.FloatSetter;
import org.sfm.reflect.primitive.IntFieldSetter;
import org.sfm.reflect.primitive.IntMethodSetter;
import org.sfm.reflect.primitive.IntSetter;
import org.sfm.reflect.primitive.LongFieldSetter;
import org.sfm.reflect.primitive.LongMethodSetter;
import org.sfm.reflect.primitive.LongSetter;
import org.sfm.reflect.primitive.ShortFieldSetter;
import org.sfm.reflect.primitive.ShortMethodSetter;
import org.sfm.reflect.primitive.ShortSetter;

public final class ObjectSetterFactory {
    private final AsmFactory asmFactory;

    public ObjectSetterFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <T, P> Setter<T, P> getSetter(Class<? extends T> target, String property) {
        Method method = this.lookForMethod(target, property);
        Setter<T, P> setter = method == null ? this.getFieldSetter(target, property) : this.getMethodSetter(method);
        return setter;
    }

    public <T, P> Setter<T, P> getMethodSetter(Method method) {
        boolean accessible;
        boolean bl = accessible = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                return this.asmFactory.createSetter(method);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!accessible) {
            method.setAccessible(true);
        }
        return new MethodSetter(method);
    }

    public <T, P> Setter<T, P> getFieldSetter(Class<?> target, String property) {
        Field field = this.lookForField(target, property);
        if (field != null) {
            return this.getFieldSetter(field);
        }
        return null;
    }

    public <T, P> Setter<T, P> getFieldSetter(Field field) {
        boolean accessible;
        boolean bl = accessible = Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
        if (this.asmFactory != null && accessible) {
            try {
                return this.asmFactory.createSetter(field);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!accessible) {
            field.setAccessible(true);
        }
        return new FieldSetter(field);
    }

    private Method lookForMethod(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (!SetterHelper.isSetter(m) || !SetterHelper.methodNameMatchesProperty(m.getName(), property)) continue;
            return m;
        }
        if (!Object.class.equals(target)) {
            return this.lookForMethod(target.getSuperclass(), property);
        }
        return null;
    }

    private Field lookForField(Class<?> target, String property) {
        if (target == null) {
            return null;
        }
        for (Field field : target.getDeclaredFields()) {
            if (!SetterHelper.fieldModifiersMatches(field.getModifiers()) || !SetterHelper.fieldNameMatchesProperty(field.getName(), property)) continue;
            return field;
        }
        if (!Object.class.equals(target)) {
            return this.lookForField(target.getSuperclass(), property);
        }
        return null;
    }

    public static <T, P> BooleanSetter<T> toBooleanSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof BooleanSetter) {
            return (BooleanSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new BooleanMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new BooleanFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    private static boolean isNullSetter(Setter<?, ?> setter) {
        return setter == null || setter instanceof NullSetter;
    }

    public static <T, P> ByteSetter<T> toByteSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof ByteSetter) {
            return (ByteSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new ByteMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new ByteFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> CharacterSetter<T> toCharacterSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof CharacterSetter) {
            return (CharacterSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new CharacterMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new CharacterFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> ShortSetter<T> toShortSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof ShortSetter) {
            return (ShortSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new ShortMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new ShortFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> IntSetter<T> toIntSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof IntSetter) {
            return (IntSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new IntMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new IntFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> LongSetter<T> toLongSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof LongSetter) {
            return (LongSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new LongMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new LongFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> FloatSetter<T> toFloatSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof FloatSetter) {
            return (FloatSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new FloatMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new FloatFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }

    public static <T, P> DoubleSetter<T> toDoubleSetter(Setter<T, ? super P> setter) {
        if (ObjectSetterFactory.isNullSetter(setter)) {
            return null;
        }
        if (setter instanceof DoubleSetter) {
            return (DoubleSetter)((Object)setter);
        }
        if (setter instanceof MethodSetter) {
            return new DoubleMethodSetter(((MethodSetter)setter).getMethod());
        }
        if (setter instanceof FieldSetter) {
            return new DoubleFieldSetter(((FieldSetter)setter).getField());
        }
        throw new IllegalArgumentException("Invalid type " + setter);
    }
}

