/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sfm.reflect.Setter;
import org.sfm.reflect.impl.NullSetter;

public class ScoredSetter<T, P> {
    private final int score;
    private final Setter<T, P> setter;

    public ScoredSetter(int score, Setter<T, P> setter) {
        this.score = score;
        this.setter = setter;
    }

    public int getScore() {
        return this.score;
    }

    public Setter<T, P> getSetter() {
        return this.setter;
    }

    public String toString() {
        return "ScoredSetter{score=" + this.score + ", setter=" + this.setter + '}';
    }

    public boolean isBetterThan(ScoredSetter<T, P> scoredSetter) {
        return this.score > scoredSetter.score;
    }

    public ScoredSetter<T, P> best(ScoredSetter<T, P> setter) {
        return this.isBetterThan(setter) ? this : setter;
    }

    public static <T, P> ScoredSetter<T, P> nullSetter() {
        return new ScoredSetter(Integer.MIN_VALUE, NullSetter.setter());
    }

    public static <T, P> ScoredSetter<T, P> ofMethod(Method method, Setter<T, P> methodSetter) {
        int score = 2;
        if (method.getName().startsWith("set")) {
            score *= 2;
        }
        return ScoredSetter.of(methodSetter, score);
    }

    public static <T, P> ScoredSetter<T, P> ofField(Field field, Setter<T, P> fieldSetter) {
        return ScoredSetter.of(fieldSetter, 1);
    }

    public static <T, P> ScoredSetter<T, P> of(Setter<T, P> methodSetter, int score) {
        return new ScoredSetter<T, P>(score, methodSetter);
    }
}

