/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.sfm.reflect.BuilderInstantiatorDefinition;
import org.sfm.reflect.ExecutableInstantiatorDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.tuples.Tuple2;

public class InstantiatorKey {
    private final Object constructor;
    private final Tuple2<String, Class>[] injectedParams;
    private final Class<?> source;

    public InstantiatorKey(Object constructor, Tuple2<String, Class>[] injectedParams, Class<?> source) {
        this.constructor = constructor;
        this.injectedParams = injectedParams;
        this.source = source;
    }

    public InstantiatorKey(Class<?> target, Class<?> source) throws NoSuchMethodException, SecurityException {
        this(target.getConstructor(new Class[0]), null, source);
    }

    public InstantiatorKey(InstantiatorDefinition instantiatorDefinition, Map injections, Class<?> source) {
        this(InstantiatorKey.getConstructor(instantiatorDefinition), InstantiatorKey.paramAndGetterClass(injections), source);
    }

    private static Object getConstructor(InstantiatorDefinition def) {
        if (def instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)def).getExecutable();
        }
        return ((BuilderInstantiatorDefinition)def).getBuildMethod();
    }

    private static Tuple2<String, Class>[] paramAndGetterClass(Map<Parameter, Getter<?, ?>> injections) {
        Tuple2[] names = new Tuple2[injections.size()];
        int i = 0;
        for (Map.Entry<Parameter, Getter<?, ?>> e : injections.entrySet()) {
            names[i++] = new Tuple2(e.getKey().getName(), e.getValue().getClass());
        }
        Arrays.sort(names, new Comparator<Tuple2<String, Class>>(){

            @Override
            public int compare(Tuple2<String, Class> o1, Tuple2<String, Class> o2) {
                return o1.first().compareTo(o2.first());
            }
        });
        return names;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 31 * result + Arrays.hashCode(this.injectedParams);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstantiatorKey other = (InstantiatorKey)obj;
        if (this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor)) {
            return false;
        }
        if (!Arrays.equals(this.injectedParams, other.injectedParams)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public Object getConstructor() {
        return this.constructor;
    }

    public String[] getInjectedParams() {
        if (this.injectedParams == null) {
            return new String[0];
        }
        String[] params = new String[this.injectedParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.injectedParams[i].first();
        }
        return params;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public Class<?> getDeclaringClass() {
        if (this.constructor instanceof Member) {
            return ((Member)this.constructor).getDeclaringClass();
        }
        if (this.constructor instanceof ExecutableInstantiatorDefinition) {
            return ((ExecutableInstantiatorDefinition)this.constructor).getExecutable().getDeclaringClass();
        }
        return ((BuilderInstantiatorDefinition)this.constructor).getBuildMethod().getDeclaringClass();
    }
}

