/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.sfm.map.FieldMapper;
import org.sfm.map.MappingContext;
import org.sfm.map.mapper.AbstractMapper;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.asm.AsmUtils;

public class MapperAsmBuilder {
    private static final String ABSTRACT_MAPPER_TYPE = AsmUtils.toType(AbstractMapper.class);
    private static final String FIELD_MAPPER_TYPE = AsmUtils.toType(FieldMapper.class);
    private static final String INSTANTIATOR_TYPE = AsmUtils.toType(Instantiator.class);
    private static final String mappingContextType = AsmUtils.toType(MappingContext.class);

    public static <S, T> byte[] dump(String className, FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, Class<? super S> sourceClass, Class<T> target) throws Exception {
        String mapper;
        String mapperName;
        int i;
        ClassWriter cw = new ClassWriter(1);
        String targetType = AsmUtils.toType(target);
        String sourceType = AsmUtils.toType(sourceClass);
        String classType = AsmUtils.toType(className);
        cw.visit(50, 49, classType, "L" + ABSTRACT_MAPPER_TYPE + "<" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + ">;", ABSTRACT_MAPPER_TYPE, null);
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.declareMapperFields(cw, mappers[i], i);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.declareConstructorMapperFields(cw, constructorMappers[i], i);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "([L" + FIELD_MAPPER_TYPE + ";[L" + FIELD_MAPPER_TYPE + ";L" + INSTANTIATOR_TYPE + ";)V", "([L" + FIELD_MAPPER_TYPE + "<L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + ">;[L" + FIELD_MAPPER_TYPE + "<L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + ">;L" + INSTANTIATOR_TYPE + "<" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + ">;;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "<init>", "(L" + INSTANTIATOR_TYPE + ";)V", false);
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.addGetterSetterInit(mv, mappers[i], i, classType);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.addGConstructorGetterSetterInit(mv, constructorMappers[i], i, classType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(17, "mapFields", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.generateMappingCall(mv, mappers[i], i, classType, sourceType, targetType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv = cw.visitMethod(4161, "mapFields", "(Ljava/lang/Object;Ljava/lang/Object;" + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, sourceType);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapFields", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(20, "mapToFields", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.generateConstructorMappingCall(mv, constructorMappers[i], i, classType, sourceType, targetType);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapFields", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(4164, "mapToFields", "(Ljava/lang/Object;Ljava/lang/Object;" + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, sourceType);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapToFields", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn((Object)"{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "appendToStringBuilder", "(Ljava/lang/StringBuilder;)V", false);
        mv.visitVarInsn(25, 1);
        for (i = 0; i < mappers.length; ++i) {
            mapperName = ", fieldMapper" + i + "=";
            mapper = String.valueOf(mappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            mapperName = ", constructorMapper" + i + "=";
            mapper = String.valueOf(constructorMappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn((Object)"}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static String toTargetTypeDeclaration(String targetType) {
        if (targetType.startsWith("[")) {
            return targetType;
        }
        return "L" + targetType + ";";
    }

    private static <S, T> void generateMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType) {
        MapperAsmBuilder.generateMappingCall(mv, mapper, index, classType, sourceType, targetType, "fieldMapper");
    }

    private static <S, T> void generateConstructorMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType) {
        MapperAsmBuilder.generateMappingCall(mv, mapper, index, classType, sourceType, targetType, "constructorMapper");
    }

    private static <S, T> void generateMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType, String variablePrefix) {
        if (mapper == null) {
            return;
        }
        Class<?> mapperClass = AsmUtils.getPublicOrInterfaceClass(mapper.getClass());
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, variablePrefix + index, "L" + AsmUtils.toType(mapperClass) + ";");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        if (AsmUtils.isStillGeneric(mapperClass)) {
            AsmUtils.invoke(mv, mapperClass, "mapTo", "(Ljava/lang/Object;Ljava/lang/Object;" + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V");
        } else {
            AsmUtils.invoke(mv, mapperClass, "mapTo", "(L" + sourceType + ";" + MapperAsmBuilder.toTargetTypeDeclaration(targetType) + MapperAsmBuilder.toTargetTypeDeclaration(mappingContextType) + ")V");
        }
    }

    private static <S, T> void addGetterSetterInit(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType) {
        if (mapper == null) {
            return;
        }
        Class<?> mapperClass = mapper.getClass();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        AsmUtils.addIndex(mv, index);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, AsmUtils.toType(mapperClass));
        mv.visitFieldInsn(181, classType, "fieldMapper" + index, MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toType(mapperClass)));
    }

    private static <S, T> void addGConstructorGetterSetterInit(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType) {
        if (mapper == null) {
            return;
        }
        Class<?> mapperClass = mapper.getClass();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        AsmUtils.addIndex(mv, index);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, AsmUtils.toType(mapperClass));
        mv.visitFieldInsn(181, classType, "constructorMapper" + index, MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toType(mapperClass)));
    }

    private static <S, T> void declareMapperFields(ClassWriter cw, FieldMapper<S, T> mapper, int index) {
        if (mapper == null) {
            return;
        }
        Class<?> mapperClass = AsmUtils.getPublicOrInterfaceClass(mapper.getClass());
        FieldVisitor fv = cw.visitField(18, "fieldMapper" + index, MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toType(mapperClass)), MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toTypeWithParam(mapperClass)), null);
        fv.visitEnd();
    }

    private static <S, T> void declareConstructorMapperFields(ClassWriter cw, FieldMapper<S, T> mapper, int index) {
        if (mapper == null) {
            return;
        }
        Class<?> mapperClass = AsmUtils.getPublicOrInterfaceClass(mapper.getClass());
        FieldVisitor fv = cw.visitField(18, "constructorMapper" + index, MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toType(mapperClass)), MapperAsmBuilder.toTargetTypeDeclaration(AsmUtils.toTypeWithParam(mapperClass)), null);
        fv.visitEnd();
    }
}

